---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractères, point exclarrogatif, ‽, 
              interrobang, combine des signes, point d'interrogation, point d'exclamation
---

# Comment obtenir le point exclarrogatif ?

Le [point exclarrogatif](wpfr:Point_exclarrogatif) "‽" combine les fonctions de point d'exclamation
et de point d'interrogation. En anglais, il se nomme *interrobang*.

Son glyphe est la superposition de ces deux signes de ponctuation.


## Avec une saisie directe

Le symbole "‽" existe dans Unicode, sous le code 8253, il est donc possible de le saisir directement. 
Mais de nombreuses polices n'ont pas le glyphe correspondant.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

\begin{document}
Comment veux-tu que je le sache ‽
\end{document}
```


## Avec une superposition de deux symboles

En arrivant à superposer un point d'interrogation à un point d'exclamation, "‽" peut être obtenu.
La commande de l'exemple suivant, `\exclarrog`, passe des commandes TeX pour obtenir ce résultat. 
La commande `\exclarrogatif` procède de façon similaire avec une syntaxe LaTeX.  

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

  \newcommand{\exclarrog}{%
    {\ooalign{?\cr\hss!\kern .025em\hss}}%
  }

  \newcommand{\exclarrogatif}{%
    \makebox[0.8pt][l]{?}!%
  }

\begin{document}
Comment veux-tu que je le sache \exclarrog

Oui, comment \exclarrogatif
\end{document}
```

Notez que ces commandes pourraient demander des réglages selon les polices utilisées.


## Avec l'extension <ctanpkg:textcomp>

:::{warning}
L’extension <ctanpkg:textcomp> est classée comme [obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit est informatif.
:::

L'extension <ctanpkg:textcomp> fournit la commande `\textinterrobang` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{textcomp}

\begin{document}
Comment veux-tu que je le sache \textinterrobang
\end{document}
```

:::{sources}
[Negative space equal the length of a string?](https://tex.stackexchange.com/questions/215254/negative-space-equal-the-length-of-a-string)
:::