# 2023-04-25 Triage Log

A week mostly dominated by noise, in particular a persistent bimodality in
keccak and cranelift-codegen. No significant changes outside of that, a
relatively equal mix of regressions and improvements. Most of the bimodality
has been removed below as it's just noise.

Triage done by **@simulacrum**.
Revision range: [74864fa496997a6498e623f0d2019ccb7eb6dad0..fdeef3ed1809aa9bd4ea9ff0fad92010c6de669c](https://perf.rust-lang.org/?start=74864fa496997a6498e623f0d2019ccb7eb6dad0&end=fdeef3ed1809aa9bd4ea9ff0fad92010c6de669c&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [0.5%, 2.2%]   | 11    |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [0.6%, 7.7%]   | 48    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-3.6%, -0.3%] | 144   |
| Improvements ✅ <br /> (secondary) | -1.6% | [-6.7%, -0.3%] | 89    |
| All ❌✅ (primary)                 | -0.9% | [-3.6%, 2.2%]  | 155   |


3 Regressions, 6 Improvements, 5 Mixed; 1 of them in rollups
60 artifact comparisons made in total

#### Regressions

Support AIX-style archive type [#106704](https://github.com/rust-lang/rust/pull/106704) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c51cf7e7ffd4ca1b7159657a76e1d4fbab18276&end=39c6804b92aa202369e402525cee329556bc1db0&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1% | [1.0%, 1.2%] | 6     |
| Regressions ❌ <br /> (secondary)  | 2.5% | [1.1%, 3.9%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.1% | [1.0%, 1.2%] | 6     |

This PR also bumped std dependencies, which likely explains the additional compile time cost in our smallest benchmarks (e.g., helloworld).

Ensure mir_drops_elaborated_and_const_checked when requiring codegen. [#110107](https://github.com/rust-lang/rust/pull/110107) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4a03f14b099bf19f0124872b3f6d99ef00db7902&end=fa4cc63a6bd6f32903269e52b8f59b284d0e76c4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 2.0% | [1.7%, 2.4%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

Per [comment on the PR](https://github.com/rust-lang/rust/pull/110107#issuecomment-1501563158) this is enabling lints to run on dead code, expected regression.

Encode lifetime param spans too [#110469](https://github.com/rust-lang/rust/pull/110469) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=80a2ec49a4ffb7a351c41c8db14711297324b587&end=37b22cf2d5d787106077d4f9ef3092ca80e92a1b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.2%, 0.7%] | 21    |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.3%, 0.9%] | 4     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.2%, 0.7%] | 21    |

[This comment](https://github.com/rust-lang/rust/pull/110469#issuecomment-1518037141) justifies the regressions.

#### Improvements

Don't allocate on SimplifyCfg/Locals/Const on every MIR pass [#110477](https://github.com/rust-lang/rust/pull/110477) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=da481403e7e3c91878ef8fe3099c04dbb862a145&end=9e7f72c57d83a6e64f54b436dc3373871c3c4bb0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.7%, -0.3%] | 10    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.7%, -0.4%] | 9     |
| All ❌✅ (primary)                 | -0.5% | [-0.7%, -0.3%] | 10    |


Rm const traits in libcore [#110393](https://github.com/rust-lang/rust/pull/110393) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d7f9e81650dcee3e2d5ad1973a71da644a2eff93&end=3a5c8e91f094bb1cb1346651fe3512f0b603d826&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-2.6%, -0.4%] | 15    |
| Improvements ✅ <br /> (secondary) | -1.7% | [-2.8%, -0.5%] | 24    |
| All ❌✅ (primary)                 | -0.9% | [-2.6%, -0.4%] | 15    |


In `LexicalResolver`, don't construct graph unless necessary. [#110527](https://github.com/rust-lang/rust/pull/110527) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7fde08365c4c3cfc9a9f8a6a02693b789adbe6da&end=23a76a8ab5f7b29a1eb7aca5f3e4c4a9b866d5b7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.8%, -0.2%] | 11    |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 4     |


Enable flatten-format-args by default. [#109999](https://github.com/rust-lang/rust/pull/109999) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8bdcc62cb0362869f0e7b43a6ae4f96b953d3cbc&end=d19b64fb54391b64ce99981577c67c93ac2a9ffa&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.5% | [-2.3%, -0.6%] | 10    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.5% | [-2.3%, -0.6%] | 10    |


Allow to feed a value in another query's cache and remove `WithOptConstParam` [#96840](https://github.com/rust-lang/rust/pull/96840) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b92a41c6760801a7128ca0ec69ba4ba9c9194054&end=1f5768bc67ecb025342770e14e03699699965706&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.6%, 0.6%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-2.1%, -0.3%] | 57    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.7%, -0.3%] | 26    |
| All ❌✅ (primary)                 | -0.8% | [-2.1%, -0.3%] | 57    |


Report allocation errors as panics [#109507](https://github.com/rust-lang/rust/pull/109507) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=21fab435da99d6ef14c1c870650ee976499564f3&end=39cf520299794e6c1b6b471db5d9935e0c6271ab&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 3     |

#### Mixed

rustc_metadata: Remove `Span` from `ModChild` [#109772](https://github.com/rust-lang/rust/pull/109772) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4e463012580415a932ae4fc255aff45982c70369&end=c609da59d9fc05b1c7dc879d79700ccd8140b5fc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.5%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 15    |
| Improvements ✅ <br /> (secondary) | -1.4% | [-4.2%, -0.4%] | 13    |
| All ❌✅ (primary)                 | -0.2% | [-0.7%, 0.5%]  | 20    |


Rollup of 10 pull requests [#110546](https://github.com/rust-lang/rust/pull/110546) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=df0d9b492da81a647eedf17210cf55b86a44888c&end=9c51cf7e7ffd4ca1b7159657a76e1d4fbab18276&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.6%  | [1.1%, 2.1%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -3.1% | [-3.1%, -3.1%] | 1     |
| All ❌✅ (primary)                 | 1.6%  | [1.1%, 2.1%]   | 3     |


resolve: Remove `module_children_untracked` [#110542](https://github.com/rust-lang/rust/pull/110542) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1151ea6006020e227c74285b24ab53b7964524e6&end=409661936f929b254ffc8adb644cf35d1f9765c4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 0.9%]   | 11    |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-1.9%, -1.0%] | 3     |
| All ❌✅ (primary)                 | 0.6%  | [-0.3%, 0.9%]  | 12    |


Turn on ConstDebugInfo pass. [#107404](https://github.com/rust-lang/rust/pull/107404) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f12a7fa00fb7a99a92661bb9ae2b768dac0c5d40&end=9e540df7931a32ca286eb2e907afde78b718fd17&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.7%]   | 12    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.4%, 0.4%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.4%  | [0.2%, 0.7%]   | 12    |


Remove the size of locals heuristic in MIR inlining [#110705](https://github.com/rust-lang/rust/pull/110705) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3462f79e94f466a56ddaccfcdd3a3d44dd1dda9f&end=915aa06700af4a2363639bae70201cd7387470ad&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.3%, 2.7%]   | 9     |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.3%, 7.9%]   | 34    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.8%, -0.2%] | 59    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.5%, -0.2%] | 46    |
| All ❌✅ (primary)                 | -0.4% | [-1.8%, 2.7%]  | 68    |
