# 2023-02-14 Triage Log

Overall a good week for performance with 77 real world crates benchmarks showing an average of nearly 1% performance improvement. Unfortunately, the largest regressions are not yet fully understood and require additional investigation. Of particular interest were some large improvements in doc builds due to storing additional metadata. However, this change might cause some crates to compile slightly slower in incremental check builds, but this is still being investigated.

Triage done by **@rylev**.
Revision range: [e4dd9edb..9bb6e60](https://perf.rust-lang.org/?start=e4dd9edb76a34ecbca539967f9662b8c0cc9c7fb&end=9bb6e60d1f1360234aae90c97964c0fa5524f141&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [0.4%, 11.0%]  | 13    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.2%, 1.6%]   | 4     |
| Improvements ✅ <br /> (primary)   | -1.4% | [-7.9%, -0.3%] | 64    |
| Improvements ✅ <br /> (secondary) | -2.1% | [-5.6%, -0.3%] | 73    |
| All ❌✅ (primary)                 | -0.9% | [-7.9%, 11.0%] | 77    |


3 Regressions, 4 Improvements, 9 Mixed; ??? of them in rollups
46 artifact comparisons made in total

#### Regressions

Rollup of 6 pull requests [#107870](https://github.com/rust-lang/rust/pull/107870) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a6975734632c4771edd45ef10e7d4753541d0f3a&end=9b8dbd558c1c4b25c55d987e22baba312ae980ad&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.5%, 1.0%] | 7     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.5%, 1.0%] | 7     |


Implement `deferred_projection_equality` for erica solver [#107507](https://github.com/rust-lang/rust/pull/107507) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5a8dfd933a70cc47e44502a20fd67dfaec6555d5&end=1623ab0246deebec4fe32dc525d20bf8a88096f2&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.7%, 1.0%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.7%, 1.0%] | 6     |


rustdoc: Remove cache for preprocessed markdown links [#107933](https://github.com/rust-lang/rust/pull/107933) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=adb4bfd25d3c1190b0e7433ef945221d8aeea427&end=00cf19a75a7055171a4ffc8cc557ff63953c9754&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2% | [1.2%, 1.2%] | 1     |
| Regressions ❌ <br /> (secondary)  | 3.9% | [3.9%, 3.9%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.2% | [1.2%, 1.2%] | 1     |
- Deemed an [acceptable trade off](https://github.com/rust-lang/rust/pull/107933#issuecomment-1426963682) for the simplification it brings.


#### Improvements

ReErased regions are local [#107688](https://github.com/rust-lang/rust/pull/107688) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3f059f60467419823e2a63d6d20f414829040f2f&end=b082e80e20475b1ec5b0bd0dd1dac3e6759c8022&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.2%, -0.3%] | 8     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-2.6%, -0.4%] | 6     |
| All ❌✅ (primary)                 | -0.8% | [-1.2%, -0.3%] | 8     |


Rollup of 8 pull requests [#107811](https://github.com/rust-lang/rust/pull/107811) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9433ba63942a736f068baacf19e5cffaff6dccc9&end=ef934d9b632b8ac00276558824664c104b92b5f0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.4%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -3.4% | [-4.2%, -1.6%] | 7     |
| All ❌✅ (primary)                 | -0.6% | [-1.4%, 0.6%]  | 8     |


Rollup of 9 pull requests [#107828](https://github.com/rust-lang/rust/pull/107828) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=575d424c94e0d4feea8cf4fcf04d47b83f28eaef&end=e7acd078f443156b95cee11759a735db1cfc796e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.6% | [-4.1%, -3.2%] | 6     |
| All ❌✅ (primary)                 | -1.3% | [-1.4%, -1.2%] | 2     |


Reduce interning [#107869](https://github.com/rust-lang/rust/pull/107869) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=59083c57d450d5be49db460fa395e472c09ff393&end=7740f9a571b3c6510607b17b29c81eeb24a7c79a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-2.6%, -0.4%] | 12    |
| All ❌✅ (primary)                 | -     | -              | 0     |


#### Mixed

Rollup of 8 pull requests [#107768](https://github.com/rust-lang/rust/pull/107768) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bd39bbb4bb92df439bf6d85470e296cc6a47ffbd&end=3f059f60467419823e2a63d6d20f414829040f2f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.7%  | [1.7%, 1.7%]   | 2     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.5%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -3.7% | [-4.2%, -3.2%] | 6     |
| All ❌✅ (primary)                 | -1.0% | [-1.5%, -0.4%] | 3     |
- Small number of regressions in secondary benchmarks in a rollup - I think we're fine calling this triaged.


Update cargo [#107778](https://github.com/rust-lang/rust/pull/107778) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b082e80e20475b1ec5b0bd0dd1dac3e6759c8022&end=7ba4e95368b2a71018cd995f5254ba3e7422954e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [0.4%, 1.5%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 3.3%  | [1.7%, 4.4%]   | 8     |
| Improvements ✅ <br /> (primary)   | -2.4% | [-7.7%, -0.4%] | 8     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.4% | [-7.7%, 1.5%]  | 11    |
- Most of the regressions are due to noise


Optimize query_cache_hit to reduce code size of the query hot path. [#107529](https://github.com/rust-lang/rust/pull/107529) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6eb9f2dd6752f591906281d8aa5e16a8c51a8801&end=a00e24d76a9ac03b146d3bf89e2161b2466c6551&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.5%, 0.5%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.1% | [-0.4%, 0.5%]  | 5     |
- Regression is small 


Optimize `TyKind::eq`. [#107717](https://github.com/rust-lang/rust/pull/107717) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ef934d9b632b8ac00276558824664c104b92b5f0&end=575d424c94e0d4feea8cf4fcf04d47b83f28eaef&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [1.0%, 1.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 3.6%  | [3.3%, 4.2%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-1.6%, -1.3%] | 2     |
| All ❌✅ (primary)                 | 1.1%  | [1.0%, 1.2%]   | 2     |
- From @nnethercote: keccak and cranelift-codegen are noisy. wg-grammar saw the expected benefit, but it's now considered non-significant, I guess it must have been a bit noisy recently as well.


Resolve documentation links in rustc and store the results in metadata [#94857](https://github.com/rust-lang/rust/pull/94857) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=71f6675de1faa2a8e897a8faaa861a0157b0e355&end=5b450244876154bc1bd134694398e80c12e00b5c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.3%, 1.5%]   | 28    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -2.4% | [-5.7%, -0.6%] | 17    |
| Improvements ✅ <br /> (secondary) | -3.4% | [-5.2%, -0.6%] | 21    |
| All ❌✅ (primary)                 | -0.6% | [-5.7%, 1.5%]  | 45    |
- Landed after an MCP and some analysis of the regressions which were deemed acceptable: https://github.com/rust-lang/rust/pull/94857#issuecomment-1414293572


simplify layout calculations in rawvec [#107167](https://github.com/rust-lang/rust/pull/107167) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5b450244876154bc1bd134694398e80c12e00b5c&end=8dabf5da9e0318f8c324dc224ad49dc91472c2ec&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.4%, -0.2%] | 9     |
| All ❌✅ (primary)                 | -0.3% | [-0.7%, 0.3%]  | 13    |
- Improvements greatly exceed regressions here.


Reverse Timsort scan direction [#107191](https://github.com/rust-lang/rust/pull/107191) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7740f9a571b3c6510607b17b29c81eeb24a7c79a&end=96834f0231277e8feb8dcf185b2af082ad2e39f6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.1% | [-0.4%, 0.6%]  | 3     |
- Regressions are small enough that I think we don't need to investigate this closely.


Improve the `array::map` codegen [#107634](https://github.com/rust-lang/rust/pull/107634) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=20081880ad2a98bbc8c8293f96c5b284d1584d86&end=2d91939bb7130a8e6c092a290b7d37f654e3c23c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.4%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 4     |
| All ❌✅ (primary)                 | -     | -              | 0     |
Perf is a wash 


rustc/rustdoc: Perform name resolver cleanups enabled by #94857 [#107765](https://github.com/rust-lang/rust/pull/107765) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c3c6d73b04a718aceabc314bf231a20c90ccd601&end=e9ab7872fd77861e3d182ea85a82c4649c5bb3f8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 13.4% | [13.4%, 13.4%] | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 3.1%  | [-0.4%, 13.4%] | 4     |
- Being investigated by @petrochenkov

