# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ACLAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Azure Networking ACL Action."""

    ALLOW = "Allow"
    DENY = "Deny"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EventListenerEndpointDiscriminator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """EventListenerEndpointDiscriminator."""

    EVENT_HUB = "EventHub"


class EventListenerFilterDiscriminator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """EventListenerFilterDiscriminator."""

    EVENT_NAME = "EventName"


class KeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of access key."""

    PRIMARY = "Primary"
    SECONDARY = "Secondary"
    SALT = "Salt"


class ManagedIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the identity type: systemAssigned, userAssigned, None."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class PrivateLinkServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
    service.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the resource."""

    UNKNOWN = "Unknown"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    RUNNING = "Running"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    MOVING = "Moving"


class ScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scale type applicable to the sku."""

    NONE = "None"
    MANUAL = "Manual"
    AUTOMATIC = "Automatic"


class ServiceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the service."""

    WEB_PUB_SUB = "WebPubSub"
    SOCKET_IO = "SocketIO"


class SharedPrivateLinkResourceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the shared private link resource."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"


class UpstreamAuthType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Upstream auth type enum."""

    NONE = "None"
    MANAGED_IDENTITY = "ManagedIdentity"


class WebPubSubRequestType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The incoming request type to the service."""

    CLIENT_CONNECTION = "ClientConnection"
    SERVER_CONNECTION = "ServerConnection"
    RESTAPI = "RESTAPI"
    TRACE = "Trace"


class WebPubSubSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional tier of this particular SKU. 'Standard' or 'Free'.

    ``Basic`` is deprecated, use ``Standard`` instead.
    """

    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
