# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementEncryptionProtectorsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_encryption_protectors_list_by_server(self, resource_group):
        response = self.client.encryption_protectors.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_encryption_protectors_get(self, resource_group):
        response = await self.client.encryption_protectors.get(
            resource_group_name=resource_group.name,
            server_name="str",
            encryption_protector_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_encryption_protectors_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.encryption_protectors.begin_create_or_update(
                resource_group_name=resource_group.name,
                server_name="str",
                encryption_protector_name="str",
                parameters={
                    "autoRotationEnabled": bool,
                    "id": "str",
                    "keyVersion": "str",
                    "kind": "str",
                    "location": "str",
                    "name": "str",
                    "serverKeyName": "str",
                    "serverKeyType": "str",
                    "subregion": "str",
                    "thumbprint": "str",
                    "type": "str",
                    "uri": "str",
                },
                api_version="2024-11-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_encryption_protectors_begin_revalidate(self, resource_group):
        response = await (
            await self.client.encryption_protectors.begin_revalidate(
                resource_group_name=resource_group.name,
                server_name="str",
                encryption_protector_name="str",
                api_version="2024-11-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
