# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Error(_serialization.Model):
    """Defines the error.

    :ivar id: The error ID.
    :vartype id: int
    :ivar code: The error code.
    :vartype code: str
    :ivar summary_message: The summarized error message.
    :vartype summary_message: str
    :ivar run_as_account_id: The account ID used to login.
    :vartype run_as_account_id: str
    :ivar message: The detailed error message.
    :vartype message: str
    :ivar possible_causes: The error possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: The error recommended action.
    :vartype recommended_action: str
    :ivar severity: The error severity.
    :vartype severity: str
    :ivar updated_time_stamp: Time when this error was last updated.
    :vartype updated_time_stamp: ~datetime.datetime
    """

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "code": {"key": "code", "type": "str"},
        "summary_message": {"key": "summaryMessage", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "updated_time_stamp": {"key": "updatedTimeStamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,  # pylint: disable=redefined-builtin
        code: Optional[str] = None,
        summary_message: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        message: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        severity: Optional[str] = None,
        updated_time_stamp: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The error ID.
        :paramtype id: int
        :keyword code: The error code.
        :paramtype code: str
        :keyword summary_message: The summarized error message.
        :paramtype summary_message: str
        :keyword run_as_account_id: The account ID used to login.
        :paramtype run_as_account_id: str
        :keyword message: The detailed error message.
        :paramtype message: str
        :keyword possible_causes: The error possible causes.
        :paramtype possible_causes: str
        :keyword recommended_action: The error recommended action.
        :paramtype recommended_action: str
        :keyword severity: The error severity.
        :paramtype severity: str
        :keyword updated_time_stamp: Time when this error was last updated.
        :paramtype updated_time_stamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id = id
        self.code = code
        self.summary_message = summary_message
        self.run_as_account_id = run_as_account_id
        self.message = message
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action
        self.severity = severity
        self.updated_time_stamp = updated_time_stamp


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.springappdiscovery.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.springappdiscovery.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.springappdiscovery.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.springappdiscovery.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorSummariesProperties(_serialization.Model):
    """Error summary properties.

    :ivar discovery_scope_error_summaries: The list of ErrorSummary.
    :vartype discovery_scope_error_summaries:
     list[~azure.mgmt.springappdiscovery.models.ErrorSummaryModel]
    :ivar errors: The list of errors.
    :vartype errors: list[~azure.mgmt.springappdiscovery.models.Error]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
    """

    _attribute_map = {
        "discovery_scope_error_summaries": {"key": "discoveryScopeErrorSummaries", "type": "[ErrorSummaryModel]"},
        "errors": {"key": "errors", "type": "[Error]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        discovery_scope_error_summaries: Optional[List["_models.ErrorSummaryModel"]] = None,
        errors: Optional[List["_models.Error"]] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword discovery_scope_error_summaries: The list of ErrorSummary.
        :paramtype discovery_scope_error_summaries:
         list[~azure.mgmt.springappdiscovery.models.ErrorSummaryModel]
        :keyword errors: The list of errors.
        :paramtype errors: list[~azure.mgmt.springappdiscovery.models.Error]
        :keyword provisioning_state: The resource provisioning state. Known values are: "Unknown",
         "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
        :paramtype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.discovery_scope_error_summaries = discovery_scope_error_summaries
        self.errors = errors
        self.provisioning_state = provisioning_state


class ErrorSummariesResourcePatch(_serialization.Model):
    """Object containing tags updates for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The ErrorSummaries resource definition.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.ErrorSummariesProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "ErrorSummariesProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ErrorSummariesProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The ErrorSummaries resource definition.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.ErrorSummariesProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ErrorSummary(ProxyResource):
    """The error summary resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.ErrorSummariesProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ErrorSummariesProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ErrorSummariesProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Resource properties.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.ErrorSummariesProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class ErrorSummaryList(_serialization.Model):
    """The list of ErrorSummary.

    :ivar value: The list of ErrorSummary.
    :vartype value: list[~azure.mgmt.springappdiscovery.models.ErrorSummary]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ErrorSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ErrorSummary"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of ErrorSummary.
        :paramtype value: list[~azure.mgmt.springappdiscovery.models.ErrorSummary]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorSummaryModel(_serialization.Model):
    """ErrorSummary model.

    :ivar affected_resource_type: The type of Object.
    :vartype affected_resource_type: str
    :ivar affected_objects_count: The count.
    :vartype affected_objects_count: int
    """

    _attribute_map = {
        "affected_resource_type": {"key": "affectedResourceType", "type": "str"},
        "affected_objects_count": {"key": "affectedObjectsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        affected_resource_type: Optional[str] = None,
        affected_objects_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword affected_resource_type: The type of Object.
        :paramtype affected_resource_type: str
        :keyword affected_objects_count: The count.
        :paramtype affected_objects_count: int
        """
        super().__init__(**kwargs)
        self.affected_resource_type = affected_resource_type
        self.affected_objects_count = affected_objects_count


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.springappdiscovery.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.springappdiscovery.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.springappdiscovery.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.springappdiscovery.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.springappdiscovery.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SpringbootappsListResult(_serialization.Model):
    """The springbootapps list resource definition.

    :ivar value: The springbootsites list.
    :vartype value: list[~azure.mgmt.springappdiscovery.models.SpringbootappsModel]
    :ivar next_link: The link used to get the next page of springbootapps resources list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SpringbootappsModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SpringbootappsModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The springbootsites list.
        :paramtype value: list[~azure.mgmt.springappdiscovery.models.SpringbootappsModel]
        :keyword next_link: The link used to get the next page of springbootapps resources list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SpringbootappsModel(ProxyResource):
    """The springbootapps envelope resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar properties: The springbootapps resource definition.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.SpringbootappsProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SpringbootappsProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.SpringbootappsProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: The springbootapps resource definition.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.SpringbootappsProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class SpringbootappsPatch(ProxyResource):
    """The springbootapps resource patch definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar properties: The springbootapps resource definition.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.SpringbootappsProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SpringbootappsProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.SpringbootappsProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: The springbootapps resource definition.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.SpringbootappsProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class SpringbootappsProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The springbootapps resource definition.

    :ivar app_name: The name of SpringBootApp.
    :vartype app_name: str
    :ivar artifact_name: The artifact name of SpringBootApp.
    :vartype artifact_name: str
    :ivar app_port: The application port.
    :vartype app_port: int
    :ivar app_type: The application type, whether it is a SpringBoot app.
    :vartype app_type: str
    :ivar application_configurations: The application configuration file list.
    :vartype application_configurations:
     list[~azure.mgmt.springappdiscovery.models.SpringbootappsPropertiesApplicationConfigurationsItem]
    :ivar binding_ports: The application binding port list.
    :vartype binding_ports: list[int]
    :ivar build_jdk_version: The jdk version in build.
    :vartype build_jdk_version: str
    :ivar certificates: The certificate file list.
    :vartype certificates: list[str]
    :ivar checksum: The checksum of jar file.
    :vartype checksum: str
    :ivar dependencies: The dependency list.
    :vartype dependencies: list[str]
    :ivar environments: The environment variable list.
    :vartype environments: list[str]
    :ivar instance_count: The total instance count the app deployed.
    :vartype instance_count: int
    :ivar jar_file_location: The jar file location on the server.
    :vartype jar_file_location: str
    :ivar jvm_memory_in_mb: The jvm heap memory allocated.
    :vartype jvm_memory_in_mb: int
    :ivar jvm_options: The jvm options.
    :vartype jvm_options: list[str]
    :ivar miscs: The other types of date collected.
    :vartype miscs: list[~azure.mgmt.springappdiscovery.models.SpringbootappsPropertiesMiscsItem]
    :ivar instances: The breakdown info for app instances on all the servers.
    :vartype instances:
     list[~azure.mgmt.springappdiscovery.models.SpringbootappsPropertiesInstancesItem]
    :ivar runtime_jdk_version: The jdk version installed on server.
    :vartype runtime_jdk_version: str
    :ivar servers: The server list the app installed.
    :vartype servers: list[str]
    :ivar machine_arm_ids: The machine ARM id list the app belongs to.
    :vartype machine_arm_ids: list[str]
    :ivar site_name: The site name.
    :vartype site_name: str
    :ivar spring_boot_version: The spring boot version.
    :vartype spring_boot_version: str
    :ivar static_content_locations: The static content location list.
    :vartype static_content_locations: list[str]
    :ivar connection_strings: The connection string list.
    :vartype connection_strings: list[str]
    :ivar last_modified_time: Time when this springbootapps jar file was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar last_updated_time: Time when this springbootapps instance was last refreshed.
    :vartype last_updated_time: ~datetime.datetime
    :ivar provisioning_state: The resource provisioning state. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
    :ivar errors: The list of errors.
    :vartype errors: list[~azure.mgmt.springappdiscovery.models.Error]
    """

    _attribute_map = {
        "app_name": {"key": "appName", "type": "str"},
        "artifact_name": {"key": "artifactName", "type": "str"},
        "app_port": {"key": "appPort", "type": "int"},
        "app_type": {"key": "appType", "type": "str"},
        "application_configurations": {
            "key": "applicationConfigurations",
            "type": "[SpringbootappsPropertiesApplicationConfigurationsItem]",
        },
        "binding_ports": {"key": "bindingPorts", "type": "[int]"},
        "build_jdk_version": {"key": "buildJdkVersion", "type": "str"},
        "certificates": {"key": "certificates", "type": "[str]"},
        "checksum": {"key": "checksum", "type": "str"},
        "dependencies": {"key": "dependencies", "type": "[str]"},
        "environments": {"key": "environments", "type": "[str]"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "jar_file_location": {"key": "jarFileLocation", "type": "str"},
        "jvm_memory_in_mb": {"key": "jvmMemoryInMB", "type": "int"},
        "jvm_options": {"key": "jvmOptions", "type": "[str]"},
        "miscs": {"key": "miscs", "type": "[SpringbootappsPropertiesMiscsItem]"},
        "instances": {"key": "instances", "type": "[SpringbootappsPropertiesInstancesItem]"},
        "runtime_jdk_version": {"key": "runtimeJdkVersion", "type": "str"},
        "servers": {"key": "servers", "type": "[str]"},
        "machine_arm_ids": {"key": "machineArmIds", "type": "[str]"},
        "site_name": {"key": "siteName", "type": "str"},
        "spring_boot_version": {"key": "springBootVersion", "type": "str"},
        "static_content_locations": {"key": "staticContentLocations", "type": "[str]"},
        "connection_strings": {"key": "connectionStrings", "type": "[str]"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "errors": {"key": "errors", "type": "[Error]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        app_name: Optional[str] = None,
        artifact_name: Optional[str] = None,
        app_port: Optional[int] = None,
        app_type: Optional[str] = None,
        application_configurations: Optional[
            List["_models.SpringbootappsPropertiesApplicationConfigurationsItem"]
        ] = None,
        binding_ports: Optional[List[int]] = None,
        build_jdk_version: Optional[str] = None,
        certificates: Optional[List[str]] = None,
        checksum: Optional[str] = None,
        dependencies: Optional[List[str]] = None,
        environments: Optional[List[str]] = None,
        instance_count: Optional[int] = None,
        jar_file_location: Optional[str] = None,
        jvm_memory_in_mb: Optional[int] = None,
        jvm_options: Optional[List[str]] = None,
        miscs: Optional[List["_models.SpringbootappsPropertiesMiscsItem"]] = None,
        instances: Optional[List["_models.SpringbootappsPropertiesInstancesItem"]] = None,
        runtime_jdk_version: Optional[str] = None,
        servers: Optional[List[str]] = None,
        machine_arm_ids: Optional[List[str]] = None,
        site_name: Optional[str] = None,
        spring_boot_version: Optional[str] = None,
        static_content_locations: Optional[List[str]] = None,
        connection_strings: Optional[List[str]] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        errors: Optional[List["_models.Error"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_name: The name of SpringBootApp.
        :paramtype app_name: str
        :keyword artifact_name: The artifact name of SpringBootApp.
        :paramtype artifact_name: str
        :keyword app_port: The application port.
        :paramtype app_port: int
        :keyword app_type: The application type, whether it is a SpringBoot app.
        :paramtype app_type: str
        :keyword application_configurations: The application configuration file list.
        :paramtype application_configurations:
         list[~azure.mgmt.springappdiscovery.models.SpringbootappsPropertiesApplicationConfigurationsItem]
        :keyword binding_ports: The application binding port list.
        :paramtype binding_ports: list[int]
        :keyword build_jdk_version: The jdk version in build.
        :paramtype build_jdk_version: str
        :keyword certificates: The certificate file list.
        :paramtype certificates: list[str]
        :keyword checksum: The checksum of jar file.
        :paramtype checksum: str
        :keyword dependencies: The dependency list.
        :paramtype dependencies: list[str]
        :keyword environments: The environment variable list.
        :paramtype environments: list[str]
        :keyword instance_count: The total instance count the app deployed.
        :paramtype instance_count: int
        :keyword jar_file_location: The jar file location on the server.
        :paramtype jar_file_location: str
        :keyword jvm_memory_in_mb: The jvm heap memory allocated.
        :paramtype jvm_memory_in_mb: int
        :keyword jvm_options: The jvm options.
        :paramtype jvm_options: list[str]
        :keyword miscs: The other types of date collected.
        :paramtype miscs: list[~azure.mgmt.springappdiscovery.models.SpringbootappsPropertiesMiscsItem]
        :keyword instances: The breakdown info for app instances on all the servers.
        :paramtype instances:
         list[~azure.mgmt.springappdiscovery.models.SpringbootappsPropertiesInstancesItem]
        :keyword runtime_jdk_version: The jdk version installed on server.
        :paramtype runtime_jdk_version: str
        :keyword servers: The server list the app installed.
        :paramtype servers: list[str]
        :keyword machine_arm_ids: The machine ARM id list the app belongs to.
        :paramtype machine_arm_ids: list[str]
        :keyword site_name: The site name.
        :paramtype site_name: str
        :keyword spring_boot_version: The spring boot version.
        :paramtype spring_boot_version: str
        :keyword static_content_locations: The static content location list.
        :paramtype static_content_locations: list[str]
        :keyword connection_strings: The connection string list.
        :paramtype connection_strings: list[str]
        :keyword last_modified_time: Time when this springbootapps jar file was last modified.
        :paramtype last_modified_time: ~datetime.datetime
        :keyword last_updated_time: Time when this springbootapps instance was last refreshed.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword provisioning_state: The resource provisioning state. Known values are: "Unknown",
         "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
        :paramtype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
        :keyword errors: The list of errors.
        :paramtype errors: list[~azure.mgmt.springappdiscovery.models.Error]
        """
        super().__init__(**kwargs)
        self.app_name = app_name
        self.artifact_name = artifact_name
        self.app_port = app_port
        self.app_type = app_type
        self.application_configurations = application_configurations
        self.binding_ports = binding_ports
        self.build_jdk_version = build_jdk_version
        self.certificates = certificates
        self.checksum = checksum
        self.dependencies = dependencies
        self.environments = environments
        self.instance_count = instance_count
        self.jar_file_location = jar_file_location
        self.jvm_memory_in_mb = jvm_memory_in_mb
        self.jvm_options = jvm_options
        self.miscs = miscs
        self.instances = instances
        self.runtime_jdk_version = runtime_jdk_version
        self.servers = servers
        self.machine_arm_ids = machine_arm_ids
        self.site_name = site_name
        self.spring_boot_version = spring_boot_version
        self.static_content_locations = static_content_locations
        self.connection_strings = connection_strings
        self.last_modified_time = last_modified_time
        self.last_updated_time = last_updated_time
        self.provisioning_state = provisioning_state
        self.errors = errors


class SpringbootappsPropertiesApplicationConfigurationsItem(_serialization.Model):
    """SpringbootappsPropertiesApplicationConfigurationsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The application config file name. Required.
    :vartype key: str
    :ivar value: The application config file content, only contains config keys.
    :vartype value: str
    """

    _validation = {
        "key": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: str, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The application config file name. Required.
        :paramtype key: str
        :keyword value: The application config file content, only contains config keys.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class SpringbootappsPropertiesInstancesItem(_serialization.Model):
    """SpringbootappsPropertiesInstancesItem.

    All required parameters must be populated in order to send to Azure.

    :ivar machine_arm_id: The machine ARM resource Id of this app instance. Required.
    :vartype machine_arm_id: str
    :ivar instance_count: The instance count of this app instance.
    :vartype instance_count: int
    :ivar jvm_memory_in_mb: The jvm heap memory allocated of this app instance.
    :vartype jvm_memory_in_mb: int
    """

    _validation = {
        "machine_arm_id": {"required": True},
    }

    _attribute_map = {
        "machine_arm_id": {"key": "machineArmId", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
        "jvm_memory_in_mb": {"key": "jvmMemoryInMB", "type": "int"},
    }

    def __init__(
        self,
        *,
        machine_arm_id: str,
        instance_count: Optional[int] = None,
        jvm_memory_in_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword machine_arm_id: The machine ARM resource Id of this app instance. Required.
        :paramtype machine_arm_id: str
        :keyword instance_count: The instance count of this app instance.
        :paramtype instance_count: int
        :keyword jvm_memory_in_mb: The jvm heap memory allocated of this app instance.
        :paramtype jvm_memory_in_mb: int
        """
        super().__init__(**kwargs)
        self.machine_arm_id = machine_arm_id
        self.instance_count = instance_count
        self.jvm_memory_in_mb = jvm_memory_in_mb


class SpringbootappsPropertiesMiscsItem(_serialization.Model):
    """SpringbootappsPropertiesMiscsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The miscs. key. Required.
    :vartype key: str
    :ivar value: The miscs. value.
    :vartype value: str
    """

    _validation = {
        "key": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: str, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The miscs. key. Required.
        :paramtype key: str
        :keyword value: The miscs. value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class SpringbootserversListResult(_serialization.Model):
    """The springbootservers list resource definition.

    :ivar value: The springbootsites list.
    :vartype value: list[~azure.mgmt.springappdiscovery.models.SpringbootserversModel]
    :ivar next_link: The link used to get the next page of springbootservers resources list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SpringbootserversModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SpringbootserversModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The springbootsites list.
        :paramtype value: list[~azure.mgmt.springappdiscovery.models.SpringbootserversModel]
        :keyword next_link: The link used to get the next page of springbootservers resources list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SpringbootserversModel(ProxyResource):
    """The springbootservers envelope resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The springbootservers resource definition.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.SpringbootserversProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "SpringbootserversProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SpringbootserversProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The springbootservers resource definition.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.SpringbootserversProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class SpringbootserversPatch(ProxyResource):
    """The springbootservers resource patch definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The springbootsites resource definition.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.SpringbootserversProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "SpringbootserversProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SpringbootserversProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The springbootsites resource definition.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.SpringbootserversProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class SpringbootserversProperties(_serialization.Model):
    """The springbootservers resource definition.

    All required parameters must be populated in order to send to Azure.

    :ivar port: Target server port for remote login.
    :vartype port: int
    :ivar server: Server is the target server name or ip address to discover of SpringBootServer.
     Required.
    :vartype server: str
    :ivar fqdn_and_ip_address_list: The alternative FQDN or IP addresses to discover for this
     server.
    :vartype fqdn_and_ip_address_list: list[str]
    :ivar machine_arm_id: The machine Id from ARM.
    :vartype machine_arm_id: str
    :ivar total_apps: The total number of apps been discovered.
    :vartype total_apps: int
    :ivar spring_boot_apps: The total number of spring boot apps been discovered.
    :vartype spring_boot_apps: int
    :ivar errors: The list of errors.
    :vartype errors: list[~azure.mgmt.springappdiscovery.models.Error]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
    """

    _validation = {
        "server": {"required": True},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
        "server": {"key": "server", "type": "str"},
        "fqdn_and_ip_address_list": {"key": "fqdnAndIpAddressList", "type": "[str]"},
        "machine_arm_id": {"key": "machineArmId", "type": "str"},
        "total_apps": {"key": "totalApps", "type": "int"},
        "spring_boot_apps": {"key": "springBootApps", "type": "int"},
        "errors": {"key": "errors", "type": "[Error]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: str,
        port: Optional[int] = None,
        fqdn_and_ip_address_list: Optional[List[str]] = None,
        machine_arm_id: Optional[str] = None,
        total_apps: Optional[int] = None,
        spring_boot_apps: Optional[int] = None,
        errors: Optional[List["_models.Error"]] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword port: Target server port for remote login.
        :paramtype port: int
        :keyword server: Server is the target server name or ip address to discover of
         SpringBootServer. Required.
        :paramtype server: str
        :keyword fqdn_and_ip_address_list: The alternative FQDN or IP addresses to discover for this
         server.
        :paramtype fqdn_and_ip_address_list: list[str]
        :keyword machine_arm_id: The machine Id from ARM.
        :paramtype machine_arm_id: str
        :keyword total_apps: The total number of apps been discovered.
        :paramtype total_apps: int
        :keyword spring_boot_apps: The total number of spring boot apps been discovered.
        :paramtype spring_boot_apps: int
        :keyword errors: The list of errors.
        :paramtype errors: list[~azure.mgmt.springappdiscovery.models.Error]
        :keyword provisioning_state: The resource provisioning state. Known values are: "Unknown",
         "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
        :paramtype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.port = port
        self.server = server
        self.fqdn_and_ip_address_list = fqdn_and_ip_address_list
        self.machine_arm_id = machine_arm_id
        self.total_apps = total_apps
        self.spring_boot_apps = spring_boot_apps
        self.errors = errors
        self.provisioning_state = provisioning_state


class SpringbootsitesListResult(_serialization.Model):
    """The springbootsites list resource definition.

    :ivar value: The springbootsites list.
    :vartype value: list[~azure.mgmt.springappdiscovery.models.SpringbootsitesModel]
    :ivar next_link: The link used to get the next page of springbootsites resources list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SpringbootsitesModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SpringbootsitesModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The springbootsites list.
        :paramtype value: list[~azure.mgmt.springappdiscovery.models.SpringbootsitesModel]
        :keyword next_link: The link used to get the next page of springbootsites resources list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class SpringbootsitesModel(TrackedResource):
    """The springbootsites envelope resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The springbootsites resource definition.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.SpringbootsitesProperties
    :ivar extended_location: The extended location definition.
    :vartype extended_location:
     ~azure.mgmt.springappdiscovery.models.SpringbootsitesModelExtendedLocation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SpringbootsitesProperties"},
        "extended_location": {"key": "extendedLocation", "type": "SpringbootsitesModelExtendedLocation"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SpringbootsitesProperties"] = None,
        extended_location: Optional["_models.SpringbootsitesModelExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The springbootsites resource definition.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.SpringbootsitesProperties
        :keyword extended_location: The extended location definition.
        :paramtype extended_location:
         ~azure.mgmt.springappdiscovery.models.SpringbootsitesModelExtendedLocation
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.extended_location = extended_location


class SpringbootsitesModelExtendedLocation(_serialization.Model):
    """The extended location definition.

    :ivar type: The extended location type.
    :vartype type: str
    :ivar name: The extended location name.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword type: The extended location type.
        :paramtype type: str
        :keyword name: The extended location name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class SpringbootsitesPatch(TrackedResource):
    """The springbootsites resource patch definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The springbootsites resource definition.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.SpringbootsitesProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SpringbootsitesProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SpringbootsitesProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The springbootsites resource definition.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.SpringbootsitesProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class SpringbootsitesProperties(_serialization.Model):
    """The springbootsites resource definition.

    :ivar master_site_id: The master site ID from Azure Migrate.
    :vartype master_site_id: str
    :ivar migrate_project_id: The migrate project ID from Azure Migrate.
    :vartype migrate_project_id: str
    :ivar provisioning_state: The resource provisioning state. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
    """

    _attribute_map = {
        "master_site_id": {"key": "masterSiteId", "type": "str"},
        "migrate_project_id": {"key": "migrateProjectId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        master_site_id: Optional[str] = None,
        migrate_project_id: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword master_site_id: The master site ID from Azure Migrate.
        :paramtype master_site_id: str
        :keyword migrate_project_id: The migrate project ID from Azure Migrate.
        :paramtype migrate_project_id: str
        :keyword provisioning_state: The resource provisioning state. Known values are: "Unknown",
         "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
        :paramtype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.master_site_id = master_site_id
        self.migrate_project_id = migrate_project_id
        self.provisioning_state = provisioning_state


class SummariesProperties(_serialization.Model):
    """Summaries properties.

    :ivar discovered_servers: The of number discovered spring boot servers.
    :vartype discovered_servers: int
    :ivar discovered_apps: The of number discovered spring boot apps.
    :vartype discovered_apps: int
    :ivar errors: The list of errors.
    :vartype errors: list[~azure.mgmt.springappdiscovery.models.Error]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
    """

    _attribute_map = {
        "discovered_servers": {"key": "discoveredServers", "type": "int"},
        "discovered_apps": {"key": "discoveredApps", "type": "int"},
        "errors": {"key": "errors", "type": "[Error]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        discovered_servers: Optional[int] = None,
        discovered_apps: Optional[int] = None,
        errors: Optional[List["_models.Error"]] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword discovered_servers: The of number discovered spring boot servers.
        :paramtype discovered_servers: int
        :keyword discovered_apps: The of number discovered spring boot apps.
        :paramtype discovered_apps: int
        :keyword errors: The list of errors.
        :paramtype errors: list[~azure.mgmt.springappdiscovery.models.Error]
        :keyword provisioning_state: The resource provisioning state. Known values are: "Unknown",
         "Succeeded", "Failed", "Canceled", "Accepted", "Provisioning", and "Deleting".
        :paramtype provisioning_state: str or ~azure.mgmt.springappdiscovery.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.discovered_servers = discovered_servers
        self.discovered_apps = discovered_apps
        self.errors = errors
        self.provisioning_state = provisioning_state


class SummariesResourcePatch(_serialization.Model):
    """Object containing tags updates for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The Summaries resource definition.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.SummariesProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "SummariesProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SummariesProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The Summaries resource definition.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.SummariesProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class Summary(ProxyResource):
    """The summary resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.springappdiscovery.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.springappdiscovery.models.SummariesProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SummariesProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.SummariesProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Resource properties.
        :paramtype properties: ~azure.mgmt.springappdiscovery.models.SummariesProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class SummaryList(_serialization.Model):
    """List of Sites.

    :ivar value: List of Sites.
    :vartype value: list[~azure.mgmt.springappdiscovery.models.Summary]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Summary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Summary"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Sites.
        :paramtype value: list[~azure.mgmt.springappdiscovery.models.Summary]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.springappdiscovery.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.springappdiscovery.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.springappdiscovery.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.springappdiscovery.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
