// |reftest| async
// This file was procedurally generated from the following sources:
// - src/dstr-assignment-for-await/array-elem-init-fn-name-class.case
// - src/dstr-assignment-for-await/default/async-gen-decl.template
/*---
description: Assignment of function `name` attribute (ClassExpression) (for-await-of statement in an async generator declaration)
esid: sec-for-in-and-for-of-statements-runtime-semantics-labelledevaluation
features: [class, destructuring-binding, async-iteration]
flags: [generated, async]
includes: [propertyHelper.js]
info: |
    IterationStatement :
      for await ( LeftHandSideExpression of AssignmentExpression ) Statement

    1. Let keyResult be the result of performing ? ForIn/OfHeadEvaluation(« »,
       AssignmentExpression, iterate).
    2. Return ? ForIn/OfBodyEvaluation(LeftHandSideExpression, Statement,
       keyResult, assignment, labelSet).

    13.7.5.13 Runtime Semantics: ForIn/OfBodyEvaluation

    [...]
    5. If destructuring is true and if lhsKind is assignment, then
       a. Assert: lhs is a LeftHandSideExpression.
       b. Let assignmentPattern be the parse of the source text corresponding to
          lhs using AssignmentPattern as the goal symbol.
    [...]

    AssignmentElement[Yield] : DestructuringAssignmentTarget Initializeropt
    [...] 7. If Initializer is present and value is undefined and
       IsAnonymousFunctionDefinition(Initializer) and IsIdentifierRef of
       DestructuringAssignmentTarget are both true, then
       a. Let hasNameProperty be ? HasOwnProperty(v, "name").
       b. If hasNameProperty is false, perform SetFunctionName(v, GetReferencedName(lref)).

---*/
let xCls, cls, xCls2;

let iterCount = 0;
async function * fn() {
  for await ([ xCls = class x {}, cls = class {}, xCls2 = class { static name() {} } ] of [[]]) {
    assert(xCls.name !== 'xCls');
    assert(xCls2.name !== 'xCls2');

    verifyProperty(cls, 'name', {
      enumerable: false,
      writable: false,
      configurable: true,
      value: 'cls'
    });


    iterCount += 1;
  }
}

let promise = fn().next();

promise
  .then(() => assert.sameValue(iterCount, 1, 'iteration occurred as expected'), $DONE)
  .then($DONE, $DONE);

