/*******************************************************************************
 *  This file is AUTOMATICALLY GENERATED by:
 *  tools/fortran_wrappers.pl include/magmablas_s.i
 *  Do not edit.
 ******************************************************************************/

#include <stdint.h>  // for uintptr_t

#include "magma_v2.h"
#include "magma_mangling.h"

// typedef from CUDADIR/src/fortran.h directory
typedef size_t devptr_t;

#ifdef PGI_FORTRAN
    #define magma_devptr(ptr_)  ((void*)              (ptr_))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (ptr_))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(ptr_))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (ptr_))
    #define magma_ddevptr(ptr_) ((double*)            (ptr_))
    #define magma_sdevptr(ptr_) ((float*)             (ptr_))
#else
    #define magma_devptr(ptr_)  ((void*)              (uintptr_t)(*(ptr_)))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (uintptr_t)(*(ptr_)))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(uintptr_t)(*(ptr_)))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (uintptr_t)(*(ptr_)))
    #define magma_ddevptr(ptr_) ((double*)            (uintptr_t)(*(ptr_)))
    #define magma_sdevptr(ptr_) ((float*)             (uintptr_t)(*(ptr_)))
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define magmablasf_stranspose_inplace FORTRAN_NAME( magmablasf_stranspose_inplace, MAGMABLASF_STRANSPOSE_INPLACE )
void magmablasf_stranspose_inplace(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_stranspose_inplace(
        *n,
        magma_sdevptr(dA), *ldda, *queue );
}

#define magmablasf_stranspose FORTRAN_NAME( magmablasf_stranspose, MAGMABLASF_STRANSPOSE )
void magmablasf_stranspose(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dAT, magma_int_t *lddat, magma_queue_t *queue )
{
    magmablas_stranspose(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dAT), *lddat, *queue );
}

#define magmablasf_sgetmatrix_transpose FORTRAN_NAME( magmablasf_sgetmatrix_transpose, MAGMABLASF_SGETMATRIX_TRANSPOSE )
void magmablasf_sgetmatrix_transpose(
    magma_int_t *m, magma_int_t *n, magma_int_t *nb,
    devptr_t *dAT, magma_int_t *ldda,
    float *hA, magma_int_t *lda,
    devptr_t *dwork, magma_int_t *lddw,
    magma_queue_t queues[2] )
{
    magmablas_sgetmatrix_transpose(
        *m, *n, *nb,
        magma_sdevptr(dAT), *ldda,
        hA, *lda,
        magma_sdevptr(dwork), *lddw,
        queues );
}

#define magmablasf_ssetmatrix_transpose FORTRAN_NAME( magmablasf_ssetmatrix_transpose, MAGMABLASF_SSETMATRIX_TRANSPOSE )
void magmablasf_ssetmatrix_transpose(
    magma_int_t *m, magma_int_t *n, magma_int_t *nb,
    float *hA, magma_int_t *lda,
    devptr_t *dAT, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lddw,
    magma_queue_t queues[2] )
{
    magmablas_ssetmatrix_transpose(
        *m, *n, *nb,
        hA, *lda,
        magma_sdevptr(dAT), *ldda,
        magma_sdevptr(dwork), *lddw,
        queues );
}

#define magmablasf_sprbt FORTRAN_NAME( magmablasf_sprbt, MAGMABLASF_SPRBT )
void magmablasf_sprbt(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *du,
    devptr_t *dv, magma_queue_t *queue )
{
    magmablas_sprbt(
        *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(du),
        magma_sdevptr(dv), *queue );
}

#define magmablasf_sprbt_mv FORTRAN_NAME( magmablasf_sprbt_mv, MAGMABLASF_SPRBT_MV )
void magmablasf_sprbt_mv(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dv,
    devptr_t *db, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_sprbt_mv(
        *n, *nrhs,
        magma_sdevptr(dv),
        magma_sdevptr(db), *lddb, *queue );
}

#define magmablasf_sprbt_mtv FORTRAN_NAME( magmablasf_sprbt_mtv, MAGMABLASF_SPRBT_MTV )
void magmablasf_sprbt_mtv(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *du,
    devptr_t *db, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_sprbt_mtv(
        *n, *nrhs,
        magma_sdevptr(du),
        magma_sdevptr(db), *lddb, *queue );
}

#define magmaf_ssytrs_gpu FORTRAN_NAME( magmaf_ssytrs_gpu, MAGMAF_SSYTRS_GPU )
void magmaf_ssytrs_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    float *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    float *dB, magma_int_t *lddb,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_ssytrs_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        dA, *ldda,
        ipiv,
        dB, *lddb,
        info, *queue );
}

#define magmablasf_sdiinertia FORTRAN_NAME( magmablasf_sdiinertia, MAGMABLASF_SDIINERTIA )
magma_int_t magmablasf_sdiinertia(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    int *dneig, magma_queue_t *queue )
{
    return magmablas_sdiinertia(
        *n,
        magma_sdevptr(dA), *ldda,
        dneig, *queue );
}

#define magmablasf_sgeadd FORTRAN_NAME( magmablasf_sgeadd, MAGMABLASF_SGEADD )
void magmablasf_sgeadd(
    magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_sgeadd(
        *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmablasf_sgeadd2 FORTRAN_NAME( magmablasf_sgeadd2, MAGMABLASF_SGEADD2 )
void magmablasf_sgeadd2(
    magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda, float *beta,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_sgeadd2(
        *m, *n, *alpha,
        magma_sdevptr(dA), *ldda, *beta,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmablasf_sgeam FORTRAN_NAME( magmablasf_sgeam, MAGMABLASF_SGEAM )
void magmablasf_sgeam(
    const char* transA, const char* transB, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda, float *beta,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_sgeam(
        magma_trans_const(*transA), magma_trans_const(*transB), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda, *beta,
        magma_sdevptr(dB), *lddb,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmablasf_ssiinertia FORTRAN_NAME( magmablasf_ssiinertia, MAGMABLASF_SSIINERTIA )
magma_int_t magmablasf_ssiinertia(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    int *dneig, magma_queue_t *queue )
{
    return magmablas_ssiinertia(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        ipiv,
        dneig, *queue );
}

#define magmablasf_slacpy FORTRAN_NAME( magmablasf_slacpy, MAGMABLASF_SLACPY )
void magmablasf_slacpy(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_slacpy(
        magma_uplo_const(*uplo), *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmablasf_slacpy_conj FORTRAN_NAME( magmablasf_slacpy_conj, MAGMABLASF_SLACPY_CONJ )
void magmablasf_slacpy_conj(
    magma_int_t *n,
    devptr_t *dA1, magma_int_t *lda1,
    devptr_t *dA2, magma_int_t *lda2, magma_queue_t *queue )
{
    magmablas_slacpy_conj(
        *n,
        magma_sdevptr(dA1), *lda1,
        magma_sdevptr(dA2), *lda2, *queue );
}

#define magmablasf_slacpy_sym_in FORTRAN_NAME( magmablasf_slacpy_sym_in, MAGMABLASF_SLACPY_SYM_IN )
void magmablasf_slacpy_sym_in(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    magma_int_t *rows,
    magma_int_t *perm,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_slacpy_sym_in(
        magma_uplo_const(*uplo), *m, *n,
        rows,
        perm,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmablasf_slacpy_sym_out FORTRAN_NAME( magmablasf_slacpy_sym_out, MAGMABLASF_SLACPY_SYM_OUT )
void magmablasf_slacpy_sym_out(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    magma_int_t *rows,
    magma_int_t *perm,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_slacpy_sym_out(
        magma_uplo_const(*uplo), *m, *n,
        rows,
        perm,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmablasf_slange FORTRAN_NAME( magmablasf_slange, MAGMABLASF_SLANGE )
float magmablasf_slange(
    const char* norm, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_slange(
        magma_norm_const(*norm), *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dwork), *lwork, *queue );
}

#define magmablasf_slansy FORTRAN_NAME( magmablasf_slansy, MAGMABLASF_SLANSY )
float magmablasf_slansy(
    const char* norm, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_slansy(
        magma_norm_const(*norm), magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dwork), *lwork, *queue );
}

#define magmablasf_slascl FORTRAN_NAME( magmablasf_slascl, MAGMABLASF_SLASCL )
void magmablasf_slascl(
    const char* type, magma_int_t *kl, magma_int_t *ku, float *cfrom, float *cto, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_slascl(
        magma_uplo_const(*type), *kl, *ku, *cfrom, *cto, *m, *n,
        magma_sdevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_slascl_2x2 FORTRAN_NAME( magmablasf_slascl_2x2, MAGMABLASF_SLASCL_2X2 )
void magmablasf_slascl_2x2(
    const char* type, magma_int_t *m,
    devptr_t *dW, magma_int_t *lddw,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_slascl_2x2(
        magma_uplo_const(*type), *m,
        magma_sdevptr(dW), *lddw,
        magma_sdevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_slascl2 FORTRAN_NAME( magmablasf_slascl2, MAGMABLASF_SLASCL2 )
void magmablasf_slascl2(
    const char* type, magma_int_t *m, magma_int_t *n,
    devptr_t *dD,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_slascl2(
        magma_uplo_const(*type), *m, *n,
        magma_sdevptr(dD),
        magma_sdevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_slascl_diag FORTRAN_NAME( magmablasf_slascl_diag, MAGMABLASF_SLASCL_DIAG )
void magmablasf_slascl_diag(
    const char* type, magma_int_t *m, magma_int_t *n,
    devptr_t *dD, magma_int_t *lddd,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_slascl_diag(
        magma_uplo_const(*type), *m, *n,
        magma_sdevptr(dD), *lddd,
        magma_sdevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_slaset FORTRAN_NAME( magmablasf_slaset, MAGMABLASF_SLASET )
void magmablasf_slaset(
    const char* uplo, magma_int_t *m, magma_int_t *n, float *offdiag, float *diag,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_slaset(
        magma_uplo_const(*uplo), *m, *n, *offdiag, *diag,
        magma_sdevptr(dA), *ldda, *queue );
}

#define magmablasf_slaset_band FORTRAN_NAME( magmablasf_slaset_band, MAGMABLASF_SLASET_BAND )
void magmablasf_slaset_band(
    const char* uplo, magma_int_t *m, magma_int_t *n, magma_int_t *k, float *offdiag, float *diag,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_slaset_band(
        magma_uplo_const(*uplo), *m, *n, *k, *offdiag, *diag,
        magma_sdevptr(dA), *ldda, *queue );
}

#define magmablasf_slaswp FORTRAN_NAME( magmablasf_slaswp, MAGMABLASF_SLASWP )
void magmablasf_slaswp(
    magma_int_t *n,
    devptr_t *dAT, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_slaswp(
        *n,
        magma_sdevptr(dAT), *ldda, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmablasf_slaswp2 FORTRAN_NAME( magmablasf_slaswp2, MAGMABLASF_SLASWP2 )
void magmablasf_slaswp2(
    magma_int_t *n,
    devptr_t *dAT, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    devptr_t *d_ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_slaswp2(
        *n,
        magma_sdevptr(dAT), *ldda, *k1, *k2,
        magma_idevptr(d_ipiv), *inci, *queue );
}

#define magmablasf_slaswp_sym FORTRAN_NAME( magmablasf_slaswp_sym, MAGMABLASF_SLASWP_SYM )
void magmablasf_slaswp_sym(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_slaswp_sym(
        *n,
        magma_sdevptr(dA), *ldda, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmablasf_slaswpx FORTRAN_NAME( magmablasf_slaswpx, MAGMABLASF_SLASWPX )
void magmablasf_slaswpx(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldx, magma_int_t *ldy, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_slaswpx(
        *n,
        magma_sdevptr(dA), *ldx, *ldy, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmaf_slaswp_rowparallel_native FORTRAN_NAME( magmaf_slaswp_rowparallel_native, MAGMAF_SLASWP_ROWPARALLEL_NATIVE )
void magmaf_slaswp_rowparallel_native(
    magma_int_t *n,
    float* input, magma_int_t *ldi,
    float* output, magma_int_t *ldo, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *pivinfo, magma_queue_t *queue )
{
    magma_slaswp_rowparallel_native(
        *n,
        input, *ldi,
        output, *ldo, *k1, *k2,
        pivinfo, *queue );
}

#define magmaf_slaswp_columnserial FORTRAN_NAME( magmaf_slaswp_columnserial, MAGMAF_SLASWP_COLUMNSERIAL )
void magmaf_slaswp_columnserial(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *lda, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *dipiv, magma_queue_t *queue )
{
    magma_slaswp_columnserial(
        *n,
        magma_sdevptr(dA), *lda, *k1, *k2,
        dipiv, *queue );
}

#define magmablasf_ssymmetrize FORTRAN_NAME( magmablasf_ssymmetrize, MAGMABLASF_SSYMMETRIZE )
void magmablasf_ssymmetrize(
    const char* uplo, magma_int_t *m,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_ssymmetrize(
        magma_uplo_const(*uplo), *m,
        magma_sdevptr(dA), *ldda, *queue );
}

#define magmablasf_ssymmetrize_tiles FORTRAN_NAME( magmablasf_ssymmetrize_tiles, MAGMABLASF_SSYMMETRIZE_TILES )
void magmablasf_ssymmetrize_tiles(
    const char* uplo, magma_int_t *m,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *ntile, magma_int_t *mstride, magma_int_t *nstride, magma_queue_t *queue )
{
    magmablas_ssymmetrize_tiles(
        magma_uplo_const(*uplo), *m,
        magma_sdevptr(dA), *ldda, *ntile, *mstride, *nstride, *queue );
}

#define magmablasf_strtri_diag FORTRAN_NAME( magmablasf_strtri_diag, MAGMABLASF_STRTRI_DIAG )
void magmablasf_strtri_diag(
    const char* uplo, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *d_dinvA, magma_queue_t *queue )
{
    magmablas_strtri_diag(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(d_dinvA), *queue );
}

#define magmaf_slarfb_gpu FORTRAN_NAME( magmaf_slarfb_gpu, MAGMAF_SLARFB_GPU )
magma_int_t magmaf_slarfb_gpu(
    const char* side, const char* trans, const char* direct, const char* storev, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork, magma_queue_t *queue )
{
    return magma_slarfb_gpu(
        magma_side_const(*side), magma_trans_const(*trans), magma_direct_const(*direct), magma_storev_const(*storev), *m, *n, *k,
        magma_sdevptr(dV), *lddv,
        magma_sdevptr(dT), *lddt,
        magma_sdevptr(dC), *lddc,
        magma_sdevptr(dwork), *ldwork, *queue );
}

#define magmaf_slarfb_gpu_gemm FORTRAN_NAME( magmaf_slarfb_gpu_gemm, MAGMAF_SLARFB_GPU_GEMM )
magma_int_t magmaf_slarfb_gpu_gemm(
    const char* side, const char* trans, const char* direct, const char* storev, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork,
    devptr_t *dworkvt, magma_int_t *ldworkvt, magma_queue_t *queue )
{
    return magma_slarfb_gpu_gemm(
        magma_side_const(*side), magma_trans_const(*trans), magma_direct_const(*direct), magma_storev_const(*storev), *m, *n, *k,
        magma_sdevptr(dV), *lddv,
        magma_sdevptr(dT), *lddt,
        magma_sdevptr(dC), *lddc,
        magma_sdevptr(dwork), *ldwork,
        magma_sdevptr(dworkvt), *ldworkvt, *queue );
}

#define magmaf_slarfbx_gpu FORTRAN_NAME( magmaf_slarfbx_gpu, MAGMAF_SLARFBX_GPU )
void magmaf_slarfbx_gpu(
    magma_int_t *m, magma_int_t *k,
    devptr_t *V, magma_int_t *ldv,
    devptr_t *dT, magma_int_t *ldt,
    devptr_t *c,
    devptr_t *dwork, magma_queue_t *queue )
{
    magma_slarfbx_gpu(
        *m, *k,
        magma_sdevptr(V), *ldv,
        magma_sdevptr(dT), *ldt,
        magma_sdevptr(c),
        magma_sdevptr(dwork), *queue );
}

#define magmaf_slarfgtx_gpu FORTRAN_NAME( magmaf_slarfgtx_gpu, MAGMAF_SLARFGTX_GPU )
void magmaf_slarfgtx_gpu(
    magma_int_t *n,
    devptr_t *dx0,
    devptr_t *dx,
    devptr_t *dtau,
    devptr_t *dxnorm,
    devptr_t *dA, magma_int_t *iter,
    devptr_t *V, magma_int_t *ldv,
    devptr_t *T, magma_int_t *ldt,
    devptr_t *dwork, magma_queue_t *queue )
{
    magma_slarfgtx_gpu(
        *n,
        magma_sdevptr(dx0),
        magma_sdevptr(dx),
        magma_sdevptr(dtau),
        magma_sdevptr(dxnorm),
        magma_sdevptr(dA), *iter,
        magma_sdevptr(V), *ldv,
        magma_sdevptr(T), *ldt,
        magma_sdevptr(dwork), *queue );
}

#define magmaf_slarfgx_gpu FORTRAN_NAME( magmaf_slarfgx_gpu, MAGMAF_SLARFGX_GPU )
void magmaf_slarfgx_gpu(
    magma_int_t *n,
    devptr_t *dx0,
    devptr_t *dx,
    devptr_t *dtau,
    devptr_t *dxnorm,
    devptr_t *dA, magma_int_t *iter, magma_queue_t *queue )
{
    magma_slarfgx_gpu(
        *n,
        magma_sdevptr(dx0),
        magma_sdevptr(dx),
        magma_sdevptr(dtau),
        magma_sdevptr(dxnorm),
        magma_sdevptr(dA), *iter, *queue );
}

#define magmaf_slarfx_gpu FORTRAN_NAME( magmaf_slarfx_gpu, MAGMAF_SLARFX_GPU )
void magmaf_slarfx_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *v,
    devptr_t *tau,
    devptr_t *C, magma_int_t *ldc,
    devptr_t *xnorm,
    devptr_t *dT, magma_int_t *iter,
    devptr_t *work, magma_queue_t *queue )
{
    magma_slarfx_gpu(
        *m, *n,
        magma_sdevptr(v),
        magma_sdevptr(tau),
        magma_sdevptr(C), *ldc,
        magma_sdevptr(xnorm),
        magma_sdevptr(dT), *iter,
        magma_sdevptr(work), *queue );
}

#define magmablasf_saxpycp FORTRAN_NAME( magmablasf_saxpycp, MAGMABLASF_SAXPYCP )
void magmablasf_saxpycp(
    magma_int_t *m,
    devptr_t *dr,
    devptr_t *dx,
    devptr_t *db, magma_queue_t *queue )
{
    magmablas_saxpycp(
        *m,
        magma_sdevptr(dr),
        magma_sdevptr(dx),
        magma_sdevptr(db), *queue );
}

#define magmablasf_sswap FORTRAN_NAME( magmablasf_sswap, MAGMABLASF_SSWAP )
void magmablasf_sswap(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_sswap(
        *n,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmablasf_sswapblk FORTRAN_NAME( magmablasf_sswapblk, MAGMABLASF_SSWAPBLK )
void magmablasf_sswapblk(
    const char* order, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_int_t *i1, magma_int_t *i2,
    magma_int_t *ipiv, magma_int_t *inci, magma_int_t *offset, magma_queue_t *queue )
{
    magmablas_sswapblk(
        magma_order_const(*order), *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *i1, *i2,
        ipiv, *inci, *offset, *queue );
}

#define magmablasf_sswapdblk FORTRAN_NAME( magmablasf_sswapdblk, MAGMABLASF_SSWAPDBLK )
void magmablasf_sswapdblk(
    magma_int_t *n, magma_int_t *nb,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *inca,
    devptr_t *dB, magma_int_t *lddb, magma_int_t *incb, magma_queue_t *queue )
{
    magmablas_sswapdblk(
        *n, *nb,
        magma_sdevptr(dA), *ldda, *inca,
        magma_sdevptr(dB), *lddb, *incb, *queue );
}

#define magmablasf_snrm2_adjust FORTRAN_NAME( magmablasf_snrm2_adjust, MAGMABLASF_SNRM2_ADJUST )
void magmablasf_snrm2_adjust(
    magma_int_t *k,
    devptr_t *dxnorm,
    devptr_t *dc, magma_queue_t *queue )
{
    magmablas_snrm2_adjust(
        *k,
        magma_sdevptr(dxnorm),
        magma_sdevptr(dc), *queue );
}

#define magmablasf_snrm2_check FORTRAN_NAME( magmablasf_snrm2_check, MAGMABLASF_SNRM2_CHECK )
void magmablasf_snrm2_check(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dxnorm,
    devptr_t *dlsticc, magma_queue_t *queue )
{
    magmablas_snrm2_check(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dxnorm),
        magma_sdevptr(dlsticc), *queue );
}

#define magmablasf_snrm2_cols FORTRAN_NAME( magmablasf_snrm2_cols, MAGMABLASF_SNRM2_COLS )
void magmablasf_snrm2_cols(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dxnorm, magma_queue_t *queue )
{
    magmablas_snrm2_cols(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dxnorm), *queue );
}

#define magmablasf_snrm2_row_check_adjust FORTRAN_NAME( magmablasf_snrm2_row_check_adjust, MAGMABLASF_SNRM2_ROW_CHECK_ADJUST )
void magmablasf_snrm2_row_check_adjust(
    magma_int_t *k, float *tol,
    devptr_t *dxnorm,
    devptr_t *dxnorm2,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dlsticc, magma_queue_t *queue )
{
    magmablas_snrm2_row_check_adjust(
        *k, *tol,
        magma_sdevptr(dxnorm),
        magma_sdevptr(dxnorm2),
        magma_sdevptr(dC), *lddc,
        magma_sdevptr(dlsticc), *queue );
}

#define magmablasf_strsv FORTRAN_NAME( magmablasf_strsv, MAGMABLASF_STRSV )
void magmablasf_strsv(
    const char* uplo, const char* transA, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *db, magma_int_t *incb, magma_queue_t *queue )
{
    magmablas_strsv(
        magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(db), *incb, *queue );
}

#define magmablasf_strsv_outofplace FORTRAN_NAME( magmablasf_strsv_outofplace, MAGMABLASF_STRSV_OUTOFPLACE )
void magmablasf_strsv_outofplace(
    const char* uplo, const char* transA, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *db, magma_int_t *incb,
    devptr_t *dx, magma_queue_t *queue, magma_int_t *flag )
{
    magmablas_strsv_outofplace(
        magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(db), *incb,
        magma_sdevptr(dx), *queue, *flag );
}

#define magmablasf_sgemv FORTRAN_NAME( magmablasf_sgemv, MAGMABLASF_SGEMV )
void magmablasf_sgemv(
    const char* trans, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, float *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_sgemv(
        magma_trans_const(*trans), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dx), *incx, *beta,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmablasf_sgemv_conj FORTRAN_NAME( magmablasf_sgemv_conj, MAGMABLASF_SGEMV_CONJ )
void magmablasf_sgemv_conj(
    magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, float *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_sgemv_conj(
        *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dx), *incx, *beta,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmablasf_ssymv FORTRAN_NAME( magmablasf_ssymv, MAGMABLASF_SSYMV )
magma_int_t magmablasf_ssymv(
    const char* uplo, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, float *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    return magmablas_ssymv(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dx), *incx, *beta,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmablasf_ssymv_work FORTRAN_NAME( magmablasf_ssymv_work, MAGMABLASF_SSYMV_WORK )
magma_int_t magmablasf_ssymv_work(
    const char* uplo, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, float *beta,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_ssymv_work(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dx), *incx, *beta,
        magma_sdevptr(dy), *incy,
        magma_sdevptr(dwork), *lwork, *queue );
}

#define magmablasf_sgemm FORTRAN_NAME( magmablasf_sgemm, MAGMABLASF_SGEMM )
void magmablasf_sgemm(
    const char* transA, const char* transB, magma_int_t *m, magma_int_t *n, magma_int_t *k, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_sgemm(
        magma_trans_const(*transA), magma_trans_const(*transB), *m, *n, *k, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmablasf_sgemm_reduce FORTRAN_NAME( magmablasf_sgemm_reduce, MAGMABLASF_SGEMM_REDUCE )
void magmablasf_sgemm_reduce(
    magma_int_t *m, magma_int_t *n, magma_int_t *k, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_sgemm_reduce(
        *m, *n, *k, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmablasf_strsm FORTRAN_NAME( magmablasf_strsm, MAGMABLASF_STRSM )
void magmablasf_strsm(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_strsm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmablasf_strsm_outofplace FORTRAN_NAME( magmablasf_strsm_outofplace, MAGMABLASF_STRSM_OUTOFPLACE )
void magmablasf_strsm_outofplace(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx, magma_int_t *flag,
    devptr_t *d_dinvA, magma_int_t *dinvA_length, magma_queue_t *queue )
{
    magmablas_strsm_outofplace(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        magma_sdevptr(dX), *lddx, *flag,
        magma_sdevptr(d_dinvA), *dinvA_length, *queue );
}

#define magmablasf_strsm_work FORTRAN_NAME( magmablasf_strsm_work, MAGMABLASF_STRSM_WORK )
void magmablasf_strsm_work(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx, magma_int_t *flag,
    devptr_t *d_dinvA, magma_int_t *dinvA_length, magma_queue_t *queue )
{
    magmablas_strsm_work(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        magma_sdevptr(dX), *lddx, *flag,
        magma_sdevptr(d_dinvA), *dinvA_length, *queue );
}

#define magmaf_ssetvector FORTRAN_NAME( magmaf_ssetvector, MAGMAF_SSETVECTOR )
void magmaf_ssetvector(
    magma_int_t *n,
    float *hx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_ssetvector(
        *n,
        hx_src, *incx,
        magma_sdevptr(dy_dst), *incy, *queue );
}

#define magmaf_sgetvector FORTRAN_NAME( magmaf_sgetvector, MAGMAF_SGETVECTOR )
void magmaf_sgetvector(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    float *hy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_sgetvector(
        *n,
        magma_sdevptr(dx_src), *incx,
        hy_dst, *incy, *queue );
}

#define magmaf_scopyvector FORTRAN_NAME( magmaf_scopyvector, MAGMAF_SCOPYVECTOR )
void magmaf_scopyvector(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_scopyvector(
        *n,
        magma_sdevptr(dx_src), *incx,
        magma_sdevptr(dy_dst), *incy, *queue );
}

#define magmaf_ssetvector_async FORTRAN_NAME( magmaf_ssetvector_async, MAGMAF_SSETVECTOR_ASYNC )
void magmaf_ssetvector_async(
    magma_int_t *n,
    float *hx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_ssetvector_async(
        *n,
        hx_src, *incx,
        magma_sdevptr(dy_dst), *incy, *queue );
}

#define magmaf_sgetvector_async FORTRAN_NAME( magmaf_sgetvector_async, MAGMAF_SGETVECTOR_ASYNC )
void magmaf_sgetvector_async(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    float *hy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_sgetvector_async(
        *n,
        magma_sdevptr(dx_src), *incx,
        hy_dst, *incy, *queue );
}

#define magmaf_scopyvector_async FORTRAN_NAME( magmaf_scopyvector_async, MAGMAF_SCOPYVECTOR_ASYNC )
void magmaf_scopyvector_async(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_scopyvector_async(
        *n,
        magma_sdevptr(dx_src), *incx,
        magma_sdevptr(dy_dst), *incy, *queue );
}

#define magmaf_ssetmatrix FORTRAN_NAME( magmaf_ssetmatrix, MAGMAF_SSETMATRIX )
void magmaf_ssetmatrix(
    magma_int_t *m, magma_int_t *n,
    float *hA_src, magma_int_t *lda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_ssetmatrix(
        *m, *n,
        hA_src, *lda,
        magma_sdevptr(dB_dst), *lddb, *queue );
}

#define magmaf_sgetmatrix FORTRAN_NAME( magmaf_sgetmatrix, MAGMAF_SGETMATRIX )
void magmaf_sgetmatrix(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    float *hB_dst, magma_int_t *ldb, magma_queue_t *queue )
{
    magma_sgetmatrix(
        *m, *n,
        magma_sdevptr(dA_src), *ldda,
        hB_dst, *ldb, *queue );
}

#define magmaf_scopymatrix FORTRAN_NAME( magmaf_scopymatrix, MAGMAF_SCOPYMATRIX )
void magmaf_scopymatrix(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_scopymatrix(
        *m, *n,
        magma_sdevptr(dA_src), *ldda,
        magma_sdevptr(dB_dst), *lddb, *queue );
}

#define magmaf_ssetmatrix_async FORTRAN_NAME( magmaf_ssetmatrix_async, MAGMAF_SSETMATRIX_ASYNC )
void magmaf_ssetmatrix_async(
    magma_int_t *m, magma_int_t *n,
    float *hA_src, magma_int_t *lda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_ssetmatrix_async(
        *m, *n,
        hA_src, *lda,
        magma_sdevptr(dB_dst), *lddb, *queue );
}

#define magmaf_sgetmatrix_async FORTRAN_NAME( magmaf_sgetmatrix_async, MAGMAF_SGETMATRIX_ASYNC )
void magmaf_sgetmatrix_async(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    float *hB_dst, magma_int_t *ldb, magma_queue_t *queue )
{
    magma_sgetmatrix_async(
        *m, *n,
        magma_sdevptr(dA_src), *ldda,
        hB_dst, *ldb, *queue );
}

#define magmaf_scopymatrix_async FORTRAN_NAME( magmaf_scopymatrix_async, MAGMAF_SCOPYMATRIX_ASYNC )
void magmaf_scopymatrix_async(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_scopymatrix_async(
        *m, *n,
        magma_sdevptr(dA_src), *ldda,
        magma_sdevptr(dB_dst), *lddb, *queue );
}

#define magmaf_isamax FORTRAN_NAME( magmaf_isamax, MAGMAF_ISAMAX )
magma_int_t magmaf_isamax(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_isamax(
        *n,
        magma_sdevptr(dx), *incx, *queue );
}

#define magmaf_isamax_native FORTRAN_NAME( magmaf_isamax_native, MAGMAF_ISAMAX_NATIVE )
void magmaf_isamax_native(
    magma_int_t *length,
    devptr_t *x, magma_int_t *incx,
    magma_int_t* ipiv,
    magma_int_t *info, magma_int_t *step, magma_int_t *gbstep, magma_queue_t *queue )
{
    magma_isamax_native(
        *length,
        magma_sdevptr(x), *incx,
        ipiv,
        info, *step, *gbstep, *queue );
}

#define magmaf_isamin FORTRAN_NAME( magmaf_isamin, MAGMAF_ISAMIN )
magma_int_t magmaf_isamin(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_isamin(
        *n,
        magma_sdevptr(dx), *incx, *queue );
}

#define magmaf_sasum FORTRAN_NAME( magmaf_sasum, MAGMAF_SASUM )
float magmaf_sasum(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_sasum(
        *n,
        magma_sdevptr(dx), *incx, *queue );
}

#define magmaf_saxpy FORTRAN_NAME( magmaf_saxpy, MAGMAF_SAXPY )
void magmaf_saxpy(
    magma_int_t *n, float *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_saxpy(
        *n, *alpha,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmaf_scopy FORTRAN_NAME( magmaf_scopy, MAGMAF_SCOPY )
void magmaf_scopy(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_scopy(
        *n,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmaf_sdot FORTRAN_NAME( magmaf_sdot, MAGMAF_SDOT )
float magmaf_sdot(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    return magma_sdot(
        *n,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmaf_snrm2 FORTRAN_NAME( magmaf_snrm2, MAGMAF_SNRM2 )
float magmaf_snrm2(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_snrm2(
        *n,
        magma_sdevptr(dx), *incx, *queue );
}

#define magmaf_srot FORTRAN_NAME( magmaf_srot, MAGMAF_SROT )
void magmaf_srot(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, float *dc, float *ds, magma_queue_t *queue )
{
    magma_srot(
        *n,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy, *dc, *ds, *queue );
}

#define magmaf_srotg FORTRAN_NAME( magmaf_srotg, MAGMAF_SROTG )
void magmaf_srotg(
    devptr_t *a,
    devptr_t *b,
    devptr_t *c,
    devptr_t *s, magma_queue_t *queue )
{
    magma_srotg(
        magma_sdevptr(a),
        magma_sdevptr(b),
        magma_sdevptr(c),
        magma_sdevptr(s), *queue );
}

#define magmaf_srotm FORTRAN_NAME( magmaf_srotm, MAGMAF_SROTM )
void magmaf_srotm(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *param, magma_queue_t *queue )
{
    magma_srotm(
        *n,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy,
        magma_sdevptr(param), *queue );
}

#define magmaf_srotmg FORTRAN_NAME( magmaf_srotmg, MAGMAF_SROTMG )
void magmaf_srotmg(
    devptr_t *d1,
    devptr_t *d2,
    devptr_t *x1,
    devptr_t *y1,
    devptr_t *param, magma_queue_t *queue )
{
    magma_srotmg(
        magma_sdevptr(d1),
        magma_sdevptr(d2),
        magma_sdevptr(x1),
        magma_sdevptr(y1),
        magma_sdevptr(param), *queue );
}

#define magmaf_sscal FORTRAN_NAME( magmaf_sscal, MAGMAF_SSCAL )
void magmaf_sscal(
    magma_int_t *n, float *alpha,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_sscal(
        *n, *alpha,
        magma_sdevptr(dx), *incx, *queue );
}

#define magmaf_sscal_sger_native FORTRAN_NAME( magmaf_sscal_sger_native, MAGMAF_SSCAL_SGER_NATIVE )
void magmaf_sscal_sger_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *lda,
    magma_int_t *info, magma_int_t *step, magma_int_t *gbstep, magma_queue_t *queue )
{
    magma_sscal_sger_native(
        *m, *n,
        magma_sdevptr(dA), *lda,
        info, *step, *gbstep, *queue );
}

#define magmaf_sswap FORTRAN_NAME( magmaf_sswap, MAGMAF_SSWAP )
void magmaf_sswap(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_sswap(
        *n,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmaf_sswap_native FORTRAN_NAME( magmaf_sswap_native, MAGMAF_SSWAP_NATIVE )
void magmaf_sswap_native(
    magma_int_t *n,
    devptr_t *x, magma_int_t *incx, magma_int_t *step,
    magma_int_t* ipiv, magma_queue_t *queue )
{
    magma_sswap_native(
        *n,
        magma_sdevptr(x), *incx, *step,
        ipiv, *queue );
}

#define magmaf_sgemv FORTRAN_NAME( magmaf_sgemv, MAGMAF_SGEMV )
void magmaf_sgemv(
    const char* transA, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, float *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_sgemv(
        magma_trans_const(*transA), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dx), *incx, *beta,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmaf_sger FORTRAN_NAME( magmaf_sger, MAGMAF_SGER )
void magmaf_sger(
    magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_sger(
        *m, *n, *alpha,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy,
        magma_sdevptr(dA), *ldda, *queue );
}

#define magmaf_ssymv FORTRAN_NAME( magmaf_ssymv, MAGMAF_SSYMV )
void magmaf_ssymv(
    const char* uplo, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, float *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_ssymv(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dx), *incx, *beta,
        magma_sdevptr(dy), *incy, *queue );
}

#define magmaf_ssyr FORTRAN_NAME( magmaf_ssyr, MAGMAF_SSYR )
void magmaf_ssyr(
    const char* uplo, magma_int_t *n, float *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_ssyr(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dA), *ldda, *queue );
}

#define magmaf_ssyr2 FORTRAN_NAME( magmaf_ssyr2, MAGMAF_SSYR2 )
void magmaf_ssyr2(
    const char* uplo, magma_int_t *n, float *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_ssyr2(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_sdevptr(dx), *incx,
        magma_sdevptr(dy), *incy,
        magma_sdevptr(dA), *ldda, *queue );
}

#define magmaf_strmv FORTRAN_NAME( magmaf_strmv, MAGMAF_STRMV )
void magmaf_strmv(
    const char* uplo, const char* trans, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_strmv(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dx), *incx, *queue );
}

#define magmablasf_strmv FORTRAN_NAME( magmablasf_strmv, MAGMABLASF_STRMV )
void magmablasf_strmv(
    const char* uplo, const char* trans, const char* diag, magma_int_t *n,
    float *dA, magma_int_t *ldda,
    float *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magmablas_strmv(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *n,
        dA, *ldda,
        dx, *incx, *queue );
}

#define magmaf_strsv FORTRAN_NAME( magmaf_strsv, MAGMAF_STRSV )
void magmaf_strsv(
    const char* uplo, const char* trans, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_strsv(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dx), *incx, *queue );
}

#define magmaf_sgemm FORTRAN_NAME( magmaf_sgemm, MAGMAF_SGEMM )
void magmaf_sgemm(
    const char* transA, const char* transB, magma_int_t *m, magma_int_t *n, magma_int_t *k, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_sgemm(
        magma_trans_const(*transA), magma_trans_const(*transB), *m, *n, *k, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmaf_ssymm FORTRAN_NAME( magmaf_ssymm, MAGMAF_SSYMM )
void magmaf_ssymm(
    const char* side, const char* uplo, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_ssymm(
        magma_side_const(*side), magma_uplo_const(*uplo), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmablasf_ssymm FORTRAN_NAME( magmablasf_ssymm, MAGMABLASF_SSYMM )
void magmablasf_ssymm(
    const char* side, const char* uplo, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_ssymm(
        magma_side_const(*side), magma_uplo_const(*uplo), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmaf_ssyr2k FORTRAN_NAME( magmaf_ssyr2k, MAGMAF_SSYR2K )
void magmaf_ssyr2k(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_ssyr2k(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmablasf_ssyr2k FORTRAN_NAME( magmablasf_ssyr2k, MAGMABLASF_SSYR2K )
void magmablasf_ssyr2k(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_ssyr2k(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmaf_ssyrk FORTRAN_NAME( magmaf_ssyrk, MAGMAF_SSYRK )
void magmaf_ssyrk(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, float *alpha,
    devptr_t *dA, magma_int_t *ldda, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_ssyrk(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_sdevptr(dA), *ldda, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmablasf_ssyrk FORTRAN_NAME( magmablasf_ssyrk, MAGMABLASF_SSYRK )
void magmablasf_ssyrk(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, float *alpha,
    devptr_t *dA, magma_int_t *ldda, float *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_ssyrk(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_sdevptr(dA), *ldda, *beta,
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmablasf_ssyrk_small_reduce FORTRAN_NAME( magmablasf_ssyrk_small_reduce, MAGMABLASF_SSYRK_SMALL_REDUCE )
void magmablasf_ssyrk_small_reduce(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, float *alpha,
    float* dA, magma_int_t *ldda, float *beta,
    float* dC, magma_int_t *lddc, magma_int_t *nthread_blocks, magma_queue_t *queue )
{
    magmablas_ssyrk_small_reduce(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        dA, *ldda, *beta,
        dC, *lddc, *nthread_blocks, *queue );
}

#define magmaf_strmm FORTRAN_NAME( magmaf_strmm, MAGMAF_STRMM )
void magmaf_strmm(
    const char* side, const char* uplo, const char* trans, const char* diag, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_strmm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmablasf_strmm FORTRAN_NAME( magmablasf_strmm, MAGMABLASF_STRMM )
void magmablasf_strmm(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, float *alpha,
    float *dA, magma_int_t *ldda,
    float *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_strmm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        dA, *ldda,
        dB, *lddb, *queue );
}

#define magmaf_strsm FORTRAN_NAME( magmaf_strsm, MAGMAF_STRSM )
void magmaf_strsm(
    const char* side, const char* uplo, const char* trans, const char* diag, magma_int_t *m, magma_int_t *n, float *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_strsm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *m, *n, *alpha,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmaf_sgetf2trsm_2d_native FORTRAN_NAME( magmaf_sgetf2trsm_2d_native, MAGMAF_SGETF2TRSM_2D_NATIVE )
void magmaf_sgetf2trsm_2d_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_sgetf2trsm_2d_native(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb, *queue );
}

#define magmaf_spotf2_lpout FORTRAN_NAME( magmaf_spotf2_lpout, MAGMAF_SPOTF2_LPOUT )
magma_int_t magmaf_spotf2_lpout(
    const char* uplo, magma_int_t *n,
    float *dA, magma_int_t *lda, magma_int_t *gbstep,
    magma_int_t *dinfo, magma_queue_t *queue )
{
    return magma_spotf2_lpout(
        magma_uplo_const(*uplo), *n,
        dA, *lda, *gbstep,
        dinfo, *queue );
}

#define magmaf_spotf2_lpin FORTRAN_NAME( magmaf_spotf2_lpin, MAGMAF_SPOTF2_LPIN )
magma_int_t magmaf_spotf2_lpin(
    const char* uplo, magma_int_t *n,
    float *dA, magma_int_t *lda, magma_int_t *gbstep,
    magma_int_t *dinfo, magma_queue_t *queue )
{
    return magma_spotf2_lpin(
        magma_uplo_const(*uplo), *n,
        dA, *lda, *gbstep,
        dinfo, *queue );
}


#ifdef __cplusplus
}
#endif
