; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=thumbv8.1m.main-none-eabihf -mattr=+mve,+execute-only | FileCheck %s
; RUN: llc < %s -mtriple=thumbv6m -mattr=+execute-only | FileCheck %s --check-prefix=V6M

declare void @ext_fn(float)

define void @test1() {
; CHECK-LABEL: test1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    movs r0, #0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    bl ext_fn
; CHECK-NEXT:    pop {r7, pc}
;
; V6M-LABEL: test1:
; V6M:       @ %bb.0: @ %entry
; V6M-NEXT:    push {r7, lr}
; V6M-NEXT:    movs r0, #0
; V6M-NEXT:    bl ext_fn
; V6M-NEXT:    pop {r7, pc}
entry:
  call void @ext_fn(float 0.000000e+00)
  ret void
}

define float @test2() {
; CHECK-LABEL: test2:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r0, #63911
; CHECK-NEXT:    movt r0, #16673
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    bx lr
;
; V6M-LABEL: test2:
; V6M:       @ %bb.0: @ %entry
; V6M-NEXT:    movs r0, #65
; V6M-NEXT:    lsls r0, r0, #8
; V6M-NEXT:    adds r0, #33
; V6M-NEXT:    lsls r0, r0, #8
; V6M-NEXT:    adds r0, #249
; V6M-NEXT:    lsls r0, r0, #8
; V6M-NEXT:    adds r0, #167
; V6M-NEXT:    bx lr
entry:
  ret float 0x40243F34E0000000
}

