; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=ppc32-- | FileCheck %s \
; RUN:   -check-prefix=PPC32
; RUN: llc -verify-machineinstrs < %s -mcpu=ppc -mtriple=powerpc64 | FileCheck %s \
; RUN:   -check-prefix=PPC64
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64le -mattr=-direct-move \
; RUN:   | FileCheck %s -check-prefix=PPC64LE
; RUN: llc -verify-machineinstrs < %s -mtriple=ppc32-- -mcpu=pwr9 \
; RUN:   | FileCheck %s -check-prefix=P9_32
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64le -mcpu=pwr9 \
; RUN:   | FileCheck %s -check-prefix=P9
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64le | FileCheck %s \
; RUN:   -check-prefix=DM

define i32 @foo() #0 {
; PPC32-LABEL: foo:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    stwu 1, -32(1)
; PPC32-NEXT:    mffs 0
; PPC32-NEXT:    stfd 0, 16(1)
; PPC32-NEXT:    lwz 3, 20(1)
; PPC32-NEXT:    clrlwi 4, 3, 30
; PPC32-NEXT:    not 3, 3
; PPC32-NEXT:    rlwinm 3, 3, 31, 31, 31
; PPC32-NEXT:    xor 3, 4, 3
; PPC32-NEXT:    stw 3, 24(1)
; PPC32-NEXT:    stw 3, 28(1)
; PPC32-NEXT:    addi 1, 1, 32
; PPC32-NEXT:    blr
;
; PPC64-LABEL: foo:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mffs 0
; PPC64-NEXT:    stfd 0, -16(1)
; PPC64-NEXT:    lwz 3, -12(1)
; PPC64-NEXT:    clrlwi 4, 3, 30
; PPC64-NEXT:    not 3, 3
; PPC64-NEXT:    rlwinm 3, 3, 31, 31, 31
; PPC64-NEXT:    xor 3, 4, 3
; PPC64-NEXT:    stw 3, -8(1)
; PPC64-NEXT:    stw 3, -4(1)
; PPC64-NEXT:    blr
;
; PPC64LE-LABEL: foo:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    mffs 0
; PPC64LE-NEXT:    stfd 0, -16(1)
; PPC64LE-NEXT:    lwz 3, -16(1)
; PPC64LE-NEXT:    clrlwi 4, 3, 30
; PPC64LE-NEXT:    not 3, 3
; PPC64LE-NEXT:    rlwinm 3, 3, 31, 31, 31
; PPC64LE-NEXT:    xor 3, 4, 3
; PPC64LE-NEXT:    stw 3, -8(1)
; PPC64LE-NEXT:    stw 3, -4(1)
; PPC64LE-NEXT:    blr
;
; P9_32-LABEL: foo:
; P9_32:       # %bb.0: # %entry
; P9_32-NEXT:    stwu 1, -32(1)
; P9_32-NEXT:    mffs 0
; P9_32-NEXT:    stfd 0, 16(1)
; P9_32-NEXT:    lwz 3, 20(1)
; P9_32-NEXT:    clrlwi 4, 3, 30
; P9_32-NEXT:    not 3, 3
; P9_32-NEXT:    rlwinm 3, 3, 31, 31, 31
; P9_32-NEXT:    xor 3, 4, 3
; P9_32-NEXT:    stw 3, 24(1)
; P9_32-NEXT:    stw 3, 28(1)
; P9_32-NEXT:    addi 1, 1, 32
; P9_32-NEXT:    blr
;
; P9-LABEL: foo:
; P9:       # %bb.0: # %entry
; P9-NEXT:    mffs 0
; P9-NEXT:    mffprd 3, 0
; P9-NEXT:    clrlwi 4, 3, 30
; P9-NEXT:    not 3, 3
; P9-NEXT:    rlwinm 3, 3, 31, 31, 31
; P9-NEXT:    xor 3, 4, 3
; P9-NEXT:    stw 3, -8(1)
; P9-NEXT:    stw 3, -4(1)
; P9-NEXT:    blr
;
; DM-LABEL: foo:
; DM:       # %bb.0: # %entry
; DM-NEXT:    mffs 0
; DM-NEXT:    mffprd 3, 0
; DM-NEXT:    clrlwi 4, 3, 30
; DM-NEXT:    not 3, 3
; DM-NEXT:    rlwinm 3, 3, 31, 31, 31
; DM-NEXT:    xor 3, 4, 3
; DM-NEXT:    stw 3, -8(1)
; DM-NEXT:    stw 3, -4(1)
; DM-NEXT:    blr
entry:
	%retval = alloca i32		; <ptr> [#uses=2]
	%tmp = alloca i32		; <ptr> [#uses=2]
	%"alloca point" = bitcast i32 0 to i32		; <i32> [#uses=0]
	%tmp1 = call i32 @llvm.get.rounding( )		; <i32> [#uses=1]
	store i32 %tmp1, ptr %tmp, align 4
	%tmp2 = load i32, ptr %tmp, align 4		; <i32> [#uses=1]
	store i32 %tmp2, ptr %retval, align 4
	br label %return

return:		; preds = %entry
	%retval3 = load i32, ptr %retval		; <i32> [#uses=1]
	ret i32 %retval3
}

define void @setrnd_tozero() #0 {
; PPC32-LABEL: setrnd_tozero:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mtfsb0 30
; PPC32-NEXT:    mtfsb1 31
; PPC32-NEXT:    blr
;
; PPC64-LABEL: setrnd_tozero:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mtfsb0 30
; PPC64-NEXT:    mtfsb1 31
; PPC64-NEXT:    blr
;
; PPC64LE-LABEL: setrnd_tozero:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    mtfsb0 30
; PPC64LE-NEXT:    mtfsb1 31
; PPC64LE-NEXT:    blr
;
; P9_32-LABEL: setrnd_tozero:
; P9_32:       # %bb.0: # %entry
; P9_32-NEXT:    mffscrni 0, 1
; P9_32-NEXT:    blr
;
; P9-LABEL: setrnd_tozero:
; P9:       # %bb.0: # %entry
; P9-NEXT:    mffscrni 0, 1
; P9-NEXT:    blr
;
; DM-LABEL: setrnd_tozero:
; DM:       # %bb.0: # %entry
; DM-NEXT:    mtfsb0 30
; DM-NEXT:    mtfsb1 31
; DM-NEXT:    blr
entry:
  call void @llvm.set.rounding(i32 0)
  ret void
}

define void @setrnd_tonearest_tieeven() #0 {
; PPC32-LABEL: setrnd_tonearest_tieeven:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mtfsb0 30
; PPC32-NEXT:    mtfsb0 31
; PPC32-NEXT:    blr
;
; PPC64-LABEL: setrnd_tonearest_tieeven:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mtfsb0 30
; PPC64-NEXT:    mtfsb0 31
; PPC64-NEXT:    blr
;
; PPC64LE-LABEL: setrnd_tonearest_tieeven:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    mtfsb0 30
; PPC64LE-NEXT:    mtfsb0 31
; PPC64LE-NEXT:    blr
;
; P9_32-LABEL: setrnd_tonearest_tieeven:
; P9_32:       # %bb.0: # %entry
; P9_32-NEXT:    mffscrni 0, 0
; P9_32-NEXT:    blr
;
; P9-LABEL: setrnd_tonearest_tieeven:
; P9:       # %bb.0: # %entry
; P9-NEXT:    mffscrni 0, 0
; P9-NEXT:    blr
;
; DM-LABEL: setrnd_tonearest_tieeven:
; DM:       # %bb.0: # %entry
; DM-NEXT:    mtfsb0 30
; DM-NEXT:    mtfsb0 31
; DM-NEXT:    blr
entry:
  call void @llvm.set.rounding(i32 1)
  ret void
}

define void @setrnd_toposinf() #0 {
; PPC32-LABEL: setrnd_toposinf:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mtfsb1 30
; PPC32-NEXT:    mtfsb0 31
; PPC32-NEXT:    blr
;
; PPC64-LABEL: setrnd_toposinf:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mtfsb1 30
; PPC64-NEXT:    mtfsb0 31
; PPC64-NEXT:    blr
;
; PPC64LE-LABEL: setrnd_toposinf:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    mtfsb1 30
; PPC64LE-NEXT:    mtfsb0 31
; PPC64LE-NEXT:    blr
;
; P9_32-LABEL: setrnd_toposinf:
; P9_32:       # %bb.0: # %entry
; P9_32-NEXT:    mffscrni 0, 2
; P9_32-NEXT:    blr
;
; P9-LABEL: setrnd_toposinf:
; P9:       # %bb.0: # %entry
; P9-NEXT:    mffscrni 0, 2
; P9-NEXT:    blr
;
; DM-LABEL: setrnd_toposinf:
; DM:       # %bb.0: # %entry
; DM-NEXT:    mtfsb1 30
; DM-NEXT:    mtfsb0 31
; DM-NEXT:    blr
entry:
  call void @llvm.set.rounding(i32 2)
  ret void
}

define void @setrnd_toneginf() #0 {
; PPC32-LABEL: setrnd_toneginf:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mtfsb1 30
; PPC32-NEXT:    mtfsb1 31
; PPC32-NEXT:    blr
;
; PPC64-LABEL: setrnd_toneginf:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mtfsb1 30
; PPC64-NEXT:    mtfsb1 31
; PPC64-NEXT:    blr
;
; PPC64LE-LABEL: setrnd_toneginf:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    mtfsb1 30
; PPC64LE-NEXT:    mtfsb1 31
; PPC64LE-NEXT:    blr
;
; P9_32-LABEL: setrnd_toneginf:
; P9_32:       # %bb.0: # %entry
; P9_32-NEXT:    mffscrni 0, 3
; P9_32-NEXT:    blr
;
; P9-LABEL: setrnd_toneginf:
; P9:       # %bb.0: # %entry
; P9-NEXT:    mffscrni 0, 3
; P9-NEXT:    blr
;
; DM-LABEL: setrnd_toneginf:
; DM:       # %bb.0: # %entry
; DM-NEXT:    mtfsb1 30
; DM-NEXT:    mtfsb1 31
; DM-NEXT:    blr
entry:
  call void @llvm.set.rounding(i32 3)
  ret void
}

define void @setrnd_var(i32 %x) #0 {
; PPC32-LABEL: setrnd_var:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    stwu 1, -16(1)
; PPC32-NEXT:    mffs 0
; PPC32-NEXT:    stfd 0, 8(1)
; PPC32-NEXT:    clrlwi 4, 3, 30
; PPC32-NEXT:    lwz 5, 12(1)
; PPC32-NEXT:    rlwinm 3, 3, 31, 31, 31
; PPC32-NEXT:    xor 3, 3, 4
; PPC32-NEXT:    xori 3, 3, 1
; PPC32-NEXT:    rlwimi 5, 3, 0, 30, 31
; PPC32-NEXT:    stw 5, 12(1)
; PPC32-NEXT:    lfd 0, 8(1)
; PPC32-NEXT:    mtfsf 255, 0
; PPC32-NEXT:    addi 1, 1, 16
; PPC32-NEXT:    blr
;
; PPC64-LABEL: setrnd_var:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mffs 0
; PPC64-NEXT:    stfd 0, -16(1)
; PPC64-NEXT:    clrlwi 4, 3, 30
; PPC64-NEXT:    rlwinm 3, 3, 31, 31, 31
; PPC64-NEXT:    ld 5, -16(1)
; PPC64-NEXT:    xor 3, 3, 4
; PPC64-NEXT:    xori 3, 3, 1
; PPC64-NEXT:    clrldi 3, 3, 32
; PPC64-NEXT:    rldimi 5, 3, 0, 62
; PPC64-NEXT:    std 5, -8(1)
; PPC64-NEXT:    lfd 0, -8(1)
; PPC64-NEXT:    mtfsf 255, 0
; PPC64-NEXT:    blr
;
; PPC64LE-LABEL: setrnd_var:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    mffs 0
; PPC64LE-NEXT:    clrlwi 4, 3, 30
; PPC64LE-NEXT:    rlwinm 3, 3, 31, 31, 31
; PPC64LE-NEXT:    stfd 0, -16(1)
; PPC64LE-NEXT:    xor 3, 3, 4
; PPC64LE-NEXT:    ld 4, -16(1)
; PPC64LE-NEXT:    xori 3, 3, 1
; PPC64LE-NEXT:    clrldi 3, 3, 32
; PPC64LE-NEXT:    rldimi 4, 3, 0, 62
; PPC64LE-NEXT:    std 4, -8(1)
; PPC64LE-NEXT:    lfd 0, -8(1)
; PPC64LE-NEXT:    mtfsf 255, 0
; PPC64LE-NEXT:    blr
;
; P9_32-LABEL: setrnd_var:
; P9_32:       # %bb.0: # %entry
; P9_32-NEXT:    stwu 1, -16(1)
; P9_32-NEXT:    clrlwi 4, 3, 30
; P9_32-NEXT:    rlwinm 3, 3, 31, 31, 31
; P9_32-NEXT:    xor 3, 3, 4
; P9_32-NEXT:    xori 3, 3, 1
; P9_32-NEXT:    stw 3, 12(1)
; P9_32-NEXT:    lfd 0, 8(1)
; P9_32-NEXT:    mffscrn 0, 0
; P9_32-NEXT:    addi 1, 1, 16
; P9_32-NEXT:    blr
;
; P9-LABEL: setrnd_var:
; P9:       # %bb.0: # %entry
; P9-NEXT:    clrlwi 4, 3, 30
; P9-NEXT:    rlwinm 3, 3, 31, 31, 31
; P9-NEXT:    xor 3, 3, 4
; P9-NEXT:    xori 3, 3, 1
; P9-NEXT:    mtfprd 0, 3
; P9-NEXT:    mffscrn 0, 0
; P9-NEXT:    blr
;
; DM-LABEL: setrnd_var:
; DM:       # %bb.0: # %entry
; DM-NEXT:    clrlwi 4, 3, 30
; DM-NEXT:    rlwinm 3, 3, 31, 31, 31
; DM-NEXT:    xor 3, 3, 4
; DM-NEXT:    xori 3, 3, 1
; DM-NEXT:    clrldi 3, 3, 32
; DM-NEXT:    mffs 0
; DM-NEXT:    mffprd 4, 0
; DM-NEXT:    rldimi 4, 3, 0, 62
; DM-NEXT:    mtfprd 0, 4
; DM-NEXT:    mtfsf 255, 0
; DM-NEXT:    blr
entry:
  call void @llvm.set.rounding(i32 %x)
  ret void
}

declare i32 @llvm.get.rounding() #0
declare void @llvm.set.rounding(i32) #0

attributes #0 = { nounwind }
