struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 419,
		.content = "Processor\t: ARMv7 Processor rev 1 (v7l)\n"
			   "processor\t: 0\n"
			   "BogoMIPS\t: 38.40\n"
			   "\n"
			   "processor\t: 1\n"
			   "BogoMIPS\t: 38.40\n"
			   "\n"
			   "processor\t: 2\n"
			   "BogoMIPS\t: 38.40\n"
			   "\n"
			   "processor\t: 3\n"
			   "BogoMIPS\t: 38.40\n"
			   "\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt \n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x2\n"
			   "CPU part\t: 0x06f\n"
			   "CPU revision\t: 1\n"
			   "\n"
			   "Hardware\t: Qualcomm MSM8974PRO-AC\n"
			   "Revision\t: 000e\n"
			   "Serial\t\t: 0000cec2000097e3\n",
	},
	{
		.path = "/system/build.prop",
		.size = 7266,
		.content = "\n"
			   "# begin build properties\n"
			   "# autogenerated by buildinfo.sh\n"
			   "ro.build.id=LMY47X\n"
			   "ro.build.display.id=LMY47X.G900AUCU4CPA1\n"
			   "ro.build.version.incremental=G900AUCU4CPA1\n"
			   "ro.build.version.sdk=22\n"
			   "ro.build.version.codename=REL\n"
			   "ro.build.version.all_codenames=REL\n"
			   "ro.build.version.release=5.1.1\n"
			   "ro.build.version.security_patch=2016-02-01\n"
			   "ro.build.version.base_os=\n"
			   "ro.build.date=Wed Jan 27 21:23:36 KST 2016\n"
			   "ro.build.date.utc=1453897416\n"
			   "ro.build.type=user\n"
			   "ro.build.user=dpi\n"
			   "ro.build.host=SWHC3812\n"
			   "ro.build.tags=release-keys\n"
			   "ro.build.flavor=klteuc-user\n"
			   "ro.product.model=SAMSUNG-SM-G900A\n"
			   "ro.product.brand=samsung\n"
			   "ro.product.name=klteuc\n"
			   "ro.product.device=klteatt\n"
			   "ro.product.board=MSM8974\n"
			   "# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			   "# use ro.product.cpu.abilist instead.\n"
			   "ro.product.cpu.abi=armeabi-v7a\n"
			   "ro.product.cpu.abi2=armeabi\n"
			   "ro.product.cpu.abilist=armeabi-v7a,armeabi\n"
			   "ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			   "ro.product.cpu.abilist64=\n"
			   "ro.product.manufacturer=samsung\n"
			   "ro.product.locale.language=en\n"
			   "ro.product.locale.region=US\n"
			   "ro.wifi.channels=\n"
			   "ro.board.platform=msm8974\n"
			   "# ro.build.product is obsolete; use ro.product.device\n"
			   "ro.build.product=klteatt\n"
			   "# Do not try to parse description, fingerprint, or thumbprint\n"
			   "ro.build.description=klteuc-user 5.1.1 LMY47X G900AUCU4CPA1 release-keys\n"
			   "ro.build.fingerprint=samsung/klteuc/klteatt:5.1.1/LMY47X/G900AUCU4CPA1:user/release-keys\n"
			   "ro.build.characteristics=att\n"
			   "# Samsung Specific Properties\n"
			   "ro.build.PDA=G900AUCU4CPA1\n"
			   "ro.build.hidden_ver=G900AUCU4CPA1\n"
			   "ro.config.rm_preload_enabled=0\n"
			   "ro.build.changelist=5869384\n"
			   "ro.product_ship=true\n"
			   "ro.chipname=MSM8974PRO\n"
			   "persist.sys.storage_preload=1\n"
			   "# end build properties\n"
			   "\n"
			   "#\n"
			   "# HWUI_BUILD_PROPERTIES\n"
			   "#\n"
			   "ro.hwui.texture_cache_size=50\n"
			   "ro.hwui.layer_cache_size=34\n"
			   "ro.hwui.path_cache_size=10\n"
			   "ro.hwui.shape_cache_size=4\n"
			   "ro.hwui.gradient_cache_size=2\n"
			   "ro.hwui.drop_shadow_cache_size=6\n"
			   "ro.hwui.r_buffer_cache_size=4\n"
			   "ro.hwui.text_small_cache_width=2048\n"
			   "ro.hwui.text_small_cache_height=2048\n"
			   "ro.hwui.text_large_cache_width=4096\n"
			   "ro.hwui.text_large_cache_height=4096\n"
			   "ro.hwui.fbo_cache_size=16\n"
			   "#\n"
			   "# from device/samsung/klteatt/system.prop\n"
			   "#\n"
			   "#\n"
			   "# system.prop for msm8974\n"
			   "#\n"
			   "\n"
			   "# LCD Density\n"
			   "ro.sf.lcd_density=480\n"
			   "\n"
			   "# Evolution RIL (8xxx)\n"
			   "rild.libpath=/system/lib/libsec-ril.so\n"
			   "rild.libargs=-d /dev/smd0\n"
			   "ril.subscription.types=NV,RUIM\n"
			   "DEVICE_PROVISIONED=1\n"
			   "\n"
			   "debug.sf.hw=1\n"
			   "debug.egl.hw=1\n"
			   "debug.composition.type=c2d\n"
			   "persist.hwc.mdpcomp.enable=true\n"
			   "debug.mdpcomp.logs=0\n"
			   "dalvik.vm.heapsize=36m\n"
			   "dev.pm.dyn_samplingrate=1\n"
			   "persist.demo.hdmirotationlock=false\n"
			   "\n"
			   "ro.hdmi.enable=true\n"
			   "persist.speaker.prot.enable=false\n"
			   "qcom.hw.aac.encoder=true\n"
			   "#\n"
			   "# system props for the cne module\n"
			   "#\n"
			   "#persist.cne.feature=1\n"
			   "\n"
			   "#system props for the MM modules\n"
			   "media.stagefright.enable-player=true\n"
			   "media.stagefright.enable-http=true\n"
			   "media.stagefright.enable-aac=true\n"
			   "media.stagefright.enable-qcp=true\n"
			   "media.stagefright.enable-fma2dp=true\n"
			   "media.stagefright.enable-scan=true\n"
			   "mmp.enable.3g2=true\n"
			   "mm.enable.smoothstreaming=true\n"
			   "media.aac_51_output_enabled=true\n"
			   "#37491 is decimal sum of supported codecs in AAL\n"
			   "#codecs: AVI AC3 ASF AAC QCP DTS 3G2 MP2TS\n"
			   "mm.enable.qcom_parser=37491\n"
			   "\n"
			   "# VIDC: debug_levels\n"
			   "# 1:ERROR 2:HIGH 4:LOW 0:NOLOGS 7:AllLOGS\n"
			   "vidc.debug.level=1\n"
			   "#\n"
			   "ro.data.large_tcp_window_size=true\n"
			   "\n"
			   "# system prop for opengles version\n"
			   "#\n"
			   "# 196608 is decimal for 0x30000 to report version 3\n"
			   "ro.opengles.version=196608\n"
			   "\n"
			   "# System property for cabl\n"
			   "ro.qualcomm.cabl=1\n"
			   "\n"
			   "#\n"
			   "# System props for bluetooth\n"
			   "# System prop to turn on hfp client\n"
			   "bluetooth.hfp.client=1\n"
			   "\n"
			   "#\n"
			   "# System props for bluetooth LE Always on feature\n"
			   "#\n"
			   "ro.bluetooth.alwaysbleon=true\n"
			   "\n"
			   "#Simulate sdcard on /data/media\n"
			   "#\n"
			   "persist.fuse_sdcard=true\n"
			   "\n"
			   "#\n"
			   "#snapdragon value add features\n"
			   "#\n"
			   "ro.qc.sdk.audio.ssr=false\n"
			   "##fluencetype can be \"fluence\" or \"fluencepro\" or \"none\"\n"
			   "ro.qc.sdk.audio.fluencetype=none\n"
			   "persist.audio.fluence.voicecall=true\n"
			   "persist.audio.fluence.voicerec=false\n"
			   "persist.audio.fluence.speaker=true\n"
			   "\n"
			   "ro.qc.sdk.sensors.gestures=true\n"
			   "ro.qc.sdk.gestures.camera=false\n"
			   "ro.qc.sdk.camera.facialproc=false\n"
			   "# system prop for NFC DT\n"
			   "ro.nfc.port=I2C\n"
			   "#property to enable user to access Google WFD settings.\n"
			   "persist.debug.wfd.enable=1\n"
			   "#property to choose between virtual/external wfd display\n"
			   "persist.sys.wfd.virtual=0\n"
			   "tunnel.audio.encode = true\n"
			   "\n"
			   "#use VERY_HIGH_QUALITY for audio resampler\n"
			   "af.resampler.quality=4\n"
			   "\n"
			   "#Buffer size in kbytes for compress offload playback\n"
			   "audio.offload.buffer.size.kb=32\n"
			   "\n"
			   "#Enable offload audio video playback by default\n"
			   "av.offload.enable=true\n"
			   "\n"
			   "#enable voice path for PCM VoIP by default\n"
			   "use.voice.path.for.pcm.voip=true\n"
			   "\n"
			   "#hwui properties\n"
			   "ro.hwui.texture_cache_size=72\n"
			   "ro.hwui.layer_cache_size=48\n"
			   "ro.hwui.r_buffer_cache_size=8\n"
			   "ro.hwui.path_cache_size=32\n"
			   "ro.hwui.gradient_cache_size=1\n"
			   "ro.hwui.drop_shadow_cache_size=6\n"
			   "ro.hwui.texture_cache_flushrate=0.4\n"
			   "ro.hwui.text_small_cache_width=1024\n"
			   "ro.hwui.text_small_cache_height=1024\n"
			   "ro.hwui.text_large_cache_width=2048\n"
			   "ro.hwui.text_large_cache_height=1024\n"
			   "\n"
			   "#disable dsp gapless mode by default\n"
			   "audio.offload.gapless.enabled=false\n"
			   "\n"
			   "\n"
			   "# Enable time services daemon\n"
			   "persist.timed.enable=true\n"
			   "\n"
			   "# Data modules (For evolution RIL model)\n"
			   "ro.use_data_netmgrd=false\n"
			   "persist.data.netmgrd.qos.enable=false\n"
			   "\n"
			   "# SAMP SDHA\n"
			   "ro.config.oomminfree_high32=73728,92160,110592,129024,147456,184320\n"
			   "\n"
			   "#\n"
			   "# ADDITIONAL_BUILD_PROPERTIES\n"
			   "#\n"
			   "ro.astcenc.astcsupport=0\n"
			   "ro.mct.compressiontype=ETC2\n"
			   "ro.config.tima=1\n"
			   "ro.config.timaversion=3.0\n"
			   "ro.config.rkp=true\n"
			   "ro.use_data_netmgrd=false\n"
			   "ro.config.alarm_alert=Morning_flower.ogg\n"
			   "ro.config.ringtone=ATT_Firefly_Default.ogg\n"
			   "ro.config.notification_sound=Whisper.ogg\n"
			   "ro.config.ringtone_2=Basic_Bell.ogg\n"
			   "ro.config.notification_sound_2=S_Charming_Bell.ogg\n"
			   "keyguard.no_require_sim=true\n"
			   "ro.com.android.dateformat=MM-dd-yyyy\n"
			   "ro.carrier=unknown\n"
			   "ro.com.google.clientidbase=android-samsung\n"
			   "ro.security.icd.flagmode=single\n"
			   "ro.vendor.extension_library=libqti-perfd-client.so\n"
			   "persist.radio.apm_sim_not_pwdn=1\n"
			   "dalvik.vm.heapstartsize=8m\n"
			   "dalvik.vm.heapgrowthlimit=128m\n"
			   "dalvik.vm.heapsize=512m\n"
			   "dalvik.vm.heaptargetutilization=0.75\n"
			   "dalvik.vm.heapminfree=2m\n"
			   "dalvik.vm.heapmaxfree=8m\n"
			   "ro.build.scafe=americano\n"
			   "ro.build.scafe.size=short\n"
			   "ro.build.scafe.shot=single\n"
			   "ro.build.scafe.cream=white\n"
			   "ro.sec.fle.encryption=true\n"
			   "ro.hdcp2.rx=tz\n"
			   "media.enable-commonsource=true\n"
			   "ro.secwvk=144\n"
			   "ro.securestorage.support=true\n"
			   "security.mdpp=None\n"
			   "ro.security.mdpp.ver=1.1\n"
			   "ro.security.mdpp.release=4\n"
			   "ro.security.vpnpp.ver=1.4\n"
			   "ro.security.vpnpp.release=5.3\n"
			   "security.mdpp.result=None\n"
			   "ro.security.mdpp.ux=Enabled\n"
			   "ro.config.dha_cached_max=8\n"
			   "ro.config.dha_empty_init=36\n"
			   "ro.config.dha_empty_max=36\n"
			   "ro.config.dha_th_rate=1.83\n"
			   "ro.config.ldha_ext_enable=true\n"
			   "ro.error.receiver.default=com.samsung.receiver.error\n"
			   "ro.security.reactive.active=1\n"
			   "ro.smps.enable=true\n"
			   "ro.setupwizard.mode=DISABLED\n"
			   "ro.com.google.clientidbase.ms=android-att-us\n"
			   "ro.com.google.clientidbase.am=android-att-us\n"
			   "ro.com.google.clientidbase.yt=android-samsung\n"
			   "ro.com.google.clientidbase.gmm=android-samsung\n"
			   "ro.com.google.gmsversion=5.1_r2\n"
			   "persist.sys.dalvik.vm.lib.2=libart.so\n"
			   "ro.build.selinux=1\n"
			   "dalvik.vm.isa.arm.features=div\n"
			   "ro.config.knox=v30\n"
			   "ro.kernel.qemu=0\n"
			   "net.bt.name=Android\n"
			   "dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			   "persist.gps.qc_nlp_in_use=1\n"
			   "persist.loc.nlp_name=com.qualcomm.location\n"
			   "ro.gps.agps_provider=1\n"
			   "ro.pip.gated=0\n"
			   "ro.build.aapt.config.prefer=xxhdpi\n"
			   "ro.build.version.sdl=2202\n"
			   "\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 115,
		.content =
			"300000 422400 652800 729600 883200 960000 1036800 1190400 1267200 1497600 1574400 1728000 1958400 2265600 2457600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "performance\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 147,
		.content = "300000 0\n"
			   "422400 0\n"
			   "652800 0\n"
			   "729600 0\n"
			   "883200 0\n"
			   "960000 0\n"
			   "1036800 0\n"
			   "1190400 0\n"
			   "1267200 0\n"
			   "1497600 0\n"
			   "1574400 0\n"
			   "1728000 0\n"
			   "1958400 0\n"
			   "2265600 0\n"
			   "2457600 1372\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 115,
		.content =
			"300000 422400 652800 729600 883200 960000 1036800 1190400 1267200 1497600 1574400 1728000 1958400 2265600 2457600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "performance\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 147,
		.content = "300000 0\n"
			   "422400 0\n"
			   "652800 0\n"
			   "729600 0\n"
			   "883200 0\n"
			   "960000 0\n"
			   "1036800 0\n"
			   "1190400 0\n"
			   "1267200 0\n"
			   "1497600 0\n"
			   "1574400 0\n"
			   "1728000 0\n"
			   "1958400 0\n"
			   "2265600 0\n"
			   "2457600 1612\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 145,
		.content = "300000 0\n"
			   "422400 0\n"
			   "652800 0\n"
			   "729600 0\n"
			   "883200 0\n"
			   "960000 0\n"
			   "1036800 0\n"
			   "1190400 0\n"
			   "1267200 0\n"
			   "1497600 0\n"
			   "1574400 0\n"
			   "1728000 0\n"
			   "1958400 0\n"
			   "2265600 0\n"
			   "2457600 11\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 115,
		.content =
			"300000 422400 652800 729600 883200 960000 1036800 1190400 1267200 1497600 1574400 1728000 1958400 2265600 2457600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "2457600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 146,
		.content = "300000 0\n"
			   "422400 0\n"
			   "652800 0\n"
			   "729600 0\n"
			   "883200 0\n"
			   "960000 0\n"
			   "1036800 0\n"
			   "1190400 0\n"
			   "1267200 0\n"
			   "1497600 0\n"
			   "1574400 0\n"
			   "1728000 0\n"
			   "1958400 0\n"
			   "2265600 0\n"
			   "2457600 208\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 2,
		.content = "8\n",
	},
	{NULL},
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "af.resampler.quality",
		.value = "4",
	},
	{
		.key = "audio.offload.buffer.size.kb",
		.value = "32",
	},
	{
		.key = "audio.offload.gapless.enabled",
		.value = "false",
	},
	{
		.key = "av.offload.enable",
		.value = "true",
	},
	{
		.key = "bluetooth.hfp.client",
		.value = "1",
	},
	{
		.key = "boot.sfbootcomplete",
		.value = "0",
	},
	{
		.key = "camera2.portability.force_api",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "div",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.composition.type",
		.value = "c2d",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "debug.sf.layerdump",
		.value = "0",
	},
	{
		.key = "dev.kies.sommode",
		.value = "TRUE",
	},
	{
		.key = "dev.kiessupport",
		.value = "TRUE",
	},
	{
		.key = "dev.pm.dyn_samplingrate",
		.value = "1",
	},
	{
		.key = "init.svc.BCS-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DR-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.SIDESYNC_service",
		.value = "running",
	},
	{
		.key = "init.svc.SMD-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.TvoutService_C",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.adsprpcd",
		.value = "running",
	},
	{
		.key = "init.svc.apaservice",
		.value = "running",
	},
	{
		.key = "init.svc.at_distributor",
		.value = "running",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.audiod",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "running",
	},
	{
		.key = "init.svc.bootchecker",
		.value = "running",
	},
	{
		.key = "init.svc.ccm",
		.value = "running",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs_service",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.diag_uart_log",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.drsd",
		.value = "running",
	},
	{
		.key = "init.svc.edmaudit",
		.value = "running",
	},
	{
		.key = "init.svc.epmlogd",
		.value = "stopped",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.icd",
		.value = "stopped",
	},
	{
		.key = "init.svc.immvibed",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.insthk",
		.value = "stopped",
	},
	{
		.key = "init.svc.ipsec-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.jackservice",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.knox",
		.value = "stopped",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.loc_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.macloader",
		.value = "stopped",
	},
	{
		.key = "init.svc.mcStarter",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mobex-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "stopped",
	},
	{
		.key = "init.svc.otp",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.powersnd",
		.value = "running",
	},
	{
		.key = "init.svc.prepare_param",
		.value = "stopped",
	},
	{
		.key = "init.svc.privatemode",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.rfs_access",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.run-mobicore",
		.value = "running",
	},
	{
		.key = "init.svc.scranton_RD",
		.value = "stopped",
	},
	{
		.key = "init.svc.scs",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdcard",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdp_cryptod",
		.value = "running",
	},
	{
		.key = "init.svc.sec-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.secure_fs",
		.value = "stopped",
	},
	{
		.key = "init.svc.secure_storage",
		.value = "running",
	},
	{
		.key = "init.svc.sensorhubservice",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.ss_kb_service",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.swapon",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.tui",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vcsFPService",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnss-service",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "installd.sdcard_manipulate_done",
		.value = "1",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "logd.auditd",
		.value = "false",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.enable-commonsource",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "37491",
	},
	{
		.key = "mm.enable.smoothstreaming",
		.value = "true",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-9510681365bb4899",
	},
	{
		.key = "net.knox.shareddevice.version",
		.value = "N/A",
	},
	{
		.key = "net.knoxscep.version",
		.value = "2.0.1",
	},
	{
		.key = "net.knoxsso.version",
		.value = "2.4.0",
	},
	{
		.key = "net.knoxvpn.version",
		.value = "2.2.2",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,70800,4096,16384,70800",
	},
	{
		.key = "net.tcp.buffersize.ethernet",
		.value = "524288,1048576,3145728,524288,1048576,2097152",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,48000,4096,8760,48000",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "61167,367002,1101005,8738,52429,262114",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "40778,244668,734003,16777,100663,301990",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "122334,734003,2202010,32040,192239,576717",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "40778,244668,734003,16777,100663,301990",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "524288,1048576,2560000,524288,1048576,2560000",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "58254,349525,1048576,58254,349525,1048576",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,1048576,4525824,524288,1048576,4525824",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "net.tcp.delack.default",
		.value = "1",
	},
	{
		.key = "net.tcp.delack.lte",
		.value = "8",
	},
	{
		.key = "net.tcp.delack.wifi",
		.value = "20",
	},
	{
		.key = "net.tcp.usercfg.default",
		.value = "0",
	},
	{
		.key = "net.tcp.usercfg.lte",
		.value = "1",
	},
	{
		.key = "net.tcp.usercfg.wifi",
		.value = "1",
	},
	{
		.key = "persist.audio.allsoundmute",
		.value = "0",
	},
	{
		.key = "persist.audio.cpufreq",
		.value = "350000",
	},
	{
		.key = "persist.audio.finemediavolume",
		.value = "0",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "false",
	},
	{
		.key = "persist.audio.globaleffect",
		.value = "0",
	},
	{
		.key = "persist.audio.headsetsysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.hphonesysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.mpseek",
		.value = "0",
	},
	{
		.key = "persist.audio.mysound",
		.value = "1",
	},
	{
		.key = "persist.audio.ringermode",
		.value = "2",
	},
	{
		.key = "persist.audio.soundalivefxsec",
		.value = "1",
	},
	{
		.key = "persist.audio.stereospeaker",
		.value = "0",
	},
	{
		.key = "persist.audio.sysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.uhqa",
		.value = "1",
	},
	{
		.key = "persist.bluetooth_fw_ver",
		.value = "bcm4350_V0301.0564.hcd",
	},
	{
		.key = "persist.cne.feature",
		.value = "0",
	},
	{
		.key = "persist.csc.nosimcountry",
		.value = "US",
	},
	{
		.key = "persist.csc.nosimlanguage",
		.value = "en",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "false",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "1",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.eons.enabled",
		.value = "true",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "1",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.loc.nlp_name",
		.value = "com.qualcomm.location",
	},
	{
		.key = "persist.radio.add_power_save",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.calldefault.simid",
		.value = "0",
	},
	{
		.key = "persist.radio.dataprefer.slotId",
		.value = "0",
	},
	{
		.key = "persist.radio.initphone-type",
		.value = "1",
	},
	{
		.key = "persist.radio.lte_vrte_ltd",
		.value = "1",
	},
	{
		.key = "persist.radio.plmnname_1",
		.value = "",
	},
	{
		.key = "persist.radio.plmnname_2",
		.value = "",
	},
	{
		.key = "persist.radio.process_sups_ind",
		.value = "0",
	},
	{
		.key = "persist.radio.rilversion",
		.value = "8",
	},
	{
		.key = "persist.ril.ims.eutranParam",
		.value = "3",
	},
	{
		.key = "persist.ril.ims.utranParam",
		.value = "0",
	},
	{
		.key = "persist.security.ams.enforcing",
		.value = "1",
	},
	{
		.key = "persist.security.tlc.ccm",
		.value = "0",
	},
	{
		.key = "persist.security.tlc.otp",
		.value = "0",
	},
	{
		.key = "persist.security.tlc.tui",
		.value = "0",
	},
	{
		.key = "persist.service.bdroid.version",
		.value = "4.1",
	},
	{
		.key = "persist.speaker.prot.enable",
		.value = "false",
	},
	{
		.key = "persist.sys.clssprld1",
		.value = "715",
	},
	{
		.key = "persist.sys.clssprld2",
		.value = "495",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.drs.date",
		.value = "Wed Jan 27 21:23:36 KST 2016",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.media.use-awesome",
		.value = "true",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.setupwizard",
		.value = "FINISH",
	},
	{
		.key = "persist.sys.ssrm_unbox_cnt",
		.value = "2",
	},
	{
		.key = "persist.sys.storage_preload",
		.value = "2",
	},
	{
		.key = "persist.sys.strict_op_enable",
		.value = "false",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/New_York",
	},
	{
		.key = "persist.sys.usb.config.extra",
		.value = "none",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.wfd.virtual",
		.value = "0",
	},
	{
		.key = "persist.sys.whitelist",
		.value = "/system/etc/whitelist_appops.xml",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "qcom.hw.aac.encoder",
		.value = "true",
	},
	{
		.key = "ril.ICC_TYPE",
		.value = "2",
	},
	{
		.key = "ril.RildInit",
		.value = "1",
	},
	{
		.key = "ril.atd_status",
		.value = "1_0_0",
	},
	{
		.key = "ril.ecclist0",
		.value = "911,112",
	},
	{
		.key = "ril.ecclist_net0",
		.value = "",
	},
	{
		.key = "ril.hasisim",
		.value = "1",
	},
	{
		.key = "ril.official_cscver",
		.value = "G900AATT4CPA1",
	},
	{
		.key = "ril.radiostate",
		.value = "0",
	},
	{
		.key = "ril.serialnumber",
		.value = "R38F40JZFMF",
	},
	{
		.key = "ril.ss.routing",
		.value = "1",
	},
	{
		.key = "ril.subscription.types",
		.value = "NV,RUIM",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib/libsec-ril.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.alarm_boot",
		.value = "false",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.astcenc.astcsupport",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.alwaysbleon",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.dun",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.6",
	},
	{
		.key = "ro.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8974",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "G900AUCU4CPA1",
	},
	{
		.key = "ro.boot.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.boot.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.nvdata_backup",
		.value = "0",
	},
	{
		.key = "ro.boot.sec_atd.tty",
		.value = "/dev/ttyHSL0",
	},
	{
		.key = "ro.boot.serialno",
		.value = "cec297e3",
	},
	{
		.key = "ro.boot.warranty_bit",
		.value = "0",
	},
	{
		.key = "ro.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.bootloader",
		.value = "G900AUCU4CPA1",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/efs/bluetooth/bt_addr",
	},
	{
		.key = "ro.build.PDA",
		.value = "G900AUCU4CPA1",
	},
	{
		.key = "ro.build.aapt.config.prefer",
		.value = "xxhdpi",
	},
	{
		.key = "ro.build.changelist",
		.value = "5869384",
	},
	{
		.key = "ro.build.characteristics",
		.value = "att",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1453897416",
	},
	{
		.key = "ro.build.date",
		.value = "Wed Jan 27 21:23:36 KST 2016",
	},
	{
		.key = "ro.build.description",
		.value = "klteuc-user 5.1.1 LMY47X G900AUCU4CPA1 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "LMY47X.G900AUCU4CPA1",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "samsung/klteuc/klteatt:5.1.1/LMY47X/G900AUCU4CPA1:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "klteuc-user",
	},
	{
		.key = "ro.build.hidden_ver",
		.value = "G900AUCU4CPA1",
	},
	{
		.key = "ro.build.host",
		.value = "SWHC3812",
	},
	{
		.key = "ro.build.id",
		.value = "LMY47X",
	},
	{
		.key = "ro.build.product",
		.value = "klteatt",
	},
	{
		.key = "ro.build.scafe.cream",
		.value = "white",
	},
	{
		.key = "ro.build.scafe.shot",
		.value = "single",
	},
	{
		.key = "ro.build.scafe.size",
		.value = "short",
	},
	{
		.key = "ro.build.scafe",
		.value = "americano",
	},
	{
		.key = "ro.build.selinux.enforce",
		.value = "1",
	},
	{
		.key = "ro.build.selinux",
		.value = "1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "dpi",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "G900AUCU4CPA1",
	},
	{
		.key = "ro.build.version.release",
		.value = "5.1.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "22",
	},
	{
		.key = "ro.build.version.sdl",
		.value = "2202",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-02-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.chipname",
		.value = "MSM8974PRO",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "5.1_r2",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Morning_flower.ogg",
	},
	{
		.key = "ro.config.dha_cached_max",
		.value = "8",
	},
	{
		.key = "ro.config.dha_empty_init",
		.value = "36",
	},
	{
		.key = "ro.config.dha_empty_max",
		.value = "36",
	},
	{
		.key = "ro.config.dha_th_rate",
		.value = "1.83",
	},
	{
		.key = "ro.config.knox",
		.value = "v30",
	},
	{
		.key = "ro.config.ldha_ext_enable",
		.value = "true",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Whisper.ogg",
	},
	{
		.key = "ro.config.notification_sound_2",
		.value = "S_Charming_Bell.ogg",
	},
	{
		.key = "ro.config.oomminfree_high32",
		.value = "73728,92160,110592,129024,147456,184320",
	},
	{
		.key = "ro.config.ringtone",
		.value = "ATT_Firefly_Default.ogg",
	},
	{
		.key = "ro.config.ringtone_2",
		.value = "Basic_Bell.ogg",
	},
	{
		.key = "ro.config.rkp",
		.value = "true",
	},
	{
		.key = "ro.config.rm_preload_enabled",
		.value = "0",
	},
	{
		.key = "ro.config.tima",
		.value = "1",
	},
	{
		.key = "ro.config.timaversion",
		.value = "3.0",
	},
	{
		.key = "ro.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.csc.country_code",
		.value = "USA",
	},
	{
		.key = "ro.csc.countryiso_code",
		.value = "US",
	},
	{
		.key = "ro.csc.sales_code",
		.value = "ATT",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.data.large_tcp_window_size",
		.value = "true",
	},
	{
		.key = "ro.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.emmc",
		.value = "true",
	},
	{
		.key = "ro.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.error.receiver.default",
		.value = "com.samsung.receiver.error",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hdcp2.rx",
		.value = "tz",
	},
	{
		.key = "ro.hdmi.enable",
		.value = "true",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.fbo_cache_size",
		.value = "16",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "2",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "34",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "10",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "4",
	},
	{
		.key = "ro.hwui.shape_cache_size",
		.value = "4",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "4096",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "4096",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "50",
	},
	{
		.key = "ro.kernel.qemu",
		.value = "0",
	},
	{
		.key = "ro.mct.compressiontype",
		.value = "ETC2",
	},
	{
		.key = "ro.nfc.port",
		.value = "I2C",
	},
	{
		.key = "ro.nvdata_backup",
		.value = "0",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.pip.gated",
		.value = "0",
	},
	{
		.key = "ro.product.board",
		.value = "MSM8974",
	},
	{
		.key = "ro.product.brand",
		.value = "samsung",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.device",
		.value = "klteatt",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "samsung",
	},
	{
		.key = "ro.product.model",
		.value = "SAMSUNG-SM-G900A",
	},
	{
		.key = "ro.product.name",
		.value = "klteuc",
	},
	{
		.key = "ro.product_ship",
		.value = "true",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "none",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.camera.facialproc",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.gestures.camera",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.sensors.gestures",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "1",
	},
	{
		.key = "ro.revision",
		.value = "14",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.sec.fle.encryption",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.securestorage.support",
		.value = "true",
	},
	{
		.key = "ro.security.icd.flagmode",
		.value = "single",
	},
	{
		.key = "ro.security.mdpp.release",
		.value = "4",
	},
	{
		.key = "ro.security.mdpp.ux",
		.value = "Enabled",
	},
	{
		.key = "ro.security.mdpp.ver",
		.value = "1.1",
	},
	{
		.key = "ro.security.reactive.active",
		.value = "1",
	},
	{
		.key = "ro.security.vpnpp.release",
		.value = "5.3",
	},
	{
		.key = "ro.security.vpnpp.ver",
		.value = "1.4",
	},
	{
		.key = "ro.secwvk",
		.value = "144",
	},
	{
		.key = "ro.serialno",
		.value = "cec297e3",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "DISABLED",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.smps.enable",
		.value = "true",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "false",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "libqti-perfd-client.so",
	},
	{
		.key = "ro.warranty_bit",
		.value = "0",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote32",
	},
	{
		.key = "secmm.player.gp.url",
		.value = "true",
	},
	{
		.key = "secmm.player.uhqamode",
		.value = "True",
	},
	{
		.key = "security.mdpp.result",
		.value = "None",
	},
	{
		.key = "security.mdpp",
		.value = "Ready",
	},
	{
		.key = "selinux.policy_version",
		.value = "SEPF_SAMSUNG-SM-G900A_5.1.1_0037",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "selinux.sec.restorecon",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.media.powersnd",
		.value = "1",
	},
	{
		.key = "storage.mmc.size",
		.value = "15758000128",
	},
	{
		.key = "storage.preload.complete",
		.value = "1",
	},
	{
		.key = "sys.adaptivedisplay.eadon",
		.value = "true",
	},
	{
		.key = "sys.dockstate",
		.value = "0",
	},
	{
		.key = "sys.enterprise.billing.version",
		.value = "1.2.0",
	},
	{
		.key = "sys.enterprise.otp.version",
		.value = "1.1.1",
	},
	{
		.key = "sys.knox.exists",
		.value = "0",
	},
	{
		.key = "sys.mobicore.loaded",
		.value = "true",
	},
	{
		.key = "sys.mobicoredaemon.enable",
		.value = "true",
	},
	{
		.key = "sys.qseecomd.enable",
		.value = "true",
	},
	{
		.key = "sys.settings_system_version",
		.value = "2",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "24300",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "0",
	},
	{
		.key = "tunnel.audio.encode",
		.value = "true",
	},
	{
		.key = "use.voice.path.for.pcm.voip",
		.value = "true",
	},
	{
		.key = "vidc.debug.level",
		.value = "1",
	},
	{
		.key = "vold.pfe",
		.value = "deactivated",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.config",
		.value = "/data/misc/wifi/WCNSS_qcom_cfg.ini",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{
		.key = "wlan.wfd.status",
		.value = "disconnected",
	},
	{NULL},
};
#endif /* __ANDROID__ */
